/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.utils.OAuthEncoder;
import com.github.scribejava.core.utils.Preconditions;

public class VkontakteApi
extends DefaultApi20 {
    private static final String AUTHORIZE_URL = "https://oauth.vk.com/authorize?client_id=%s&redirect_uri=%s&response_type=code";
    private static final String SCOPED_AUTHORIZE_URL = String.format("%s&scope=%%s", "https://oauth.vk.com/authorize?client_id=%s&redirect_uri=%s&response_type=code");

    protected VkontakteApi() {
    }

    public static VkontakteApi instance() {
        return InstanceHolder.INSTANCE;
    }

    public Verb getAccessTokenVerb() {
        return Verb.GET;
    }

    public String getAccessTokenEndpoint() {
        return "https://oauth.vk.com/access_token";
    }

    public String getAuthorizationUrl(OAuthConfig config) {
        Preconditions.checkValidUrl((String)config.getCallback(), (String)"Valid url is required for a callback. Vkontakte does not support OOB");
        if (config.hasScope()) {
            return String.format(SCOPED_AUTHORIZE_URL, config.getApiKey(), OAuthEncoder.encode((String)config.getCallback()), OAuthEncoder.encode((String)config.getScope()));
        }
        return String.format(AUTHORIZE_URL, config.getApiKey(), OAuthEncoder.encode((String)config.getCallback()));
    }

    private static class InstanceHolder {
        private static final VkontakteApi INSTANCE = new VkontakteApi();

        private InstanceHolder() {
        }
    }
}

