/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis;

import com.github.scribejava.core.builder.api.DefaultApi10a;
import com.github.scribejava.core.model.OAuth1RequestToken;

public class EvernoteApi
extends DefaultApi10a {
    protected EvernoteApi() {
    }

    public static EvernoteApi instance() {
        return InstanceHolder.INSTANCE;
    }

    protected String serviceUrl() {
        return "https://www.evernote.com";
    }

    public String getRequestTokenEndpoint() {
        return this.serviceUrl() + "/oauth";
    }

    public String getAccessTokenEndpoint() {
        return this.serviceUrl() + "/oauth";
    }

    public String getAuthorizationUrl(OAuth1RequestToken requestToken) {
        return String.format(this.serviceUrl() + "/OAuth.action?oauth_token=%s", requestToken.getToken());
    }

    public static class Yinxiang
    extends EvernoteApi {
        private Yinxiang() {
        }

        public static Yinxiang instance() {
            return InstanceHolder.INSTANCE;
        }

        @Override
        protected String serviceUrl() {
            return "https://app.yinxiang.com";
        }

        private static class InstanceHolder {
            private static final Yinxiang INSTANCE = new Yinxiang();

            private InstanceHolder() {
            }
        }
    }

    public static class Sandbox
    extends EvernoteApi {
        private Sandbox() {
        }

        public static Sandbox instance() {
            return InstanceHolder.INSTANCE;
        }

        @Override
        protected String serviceUrl() {
            return "https://sandbox.evernote.com";
        }

        private static class InstanceHolder {
            private static final Sandbox INSTANCE = new Sandbox();

            private InstanceHolder() {
            }
        }
    }

    private static class InstanceHolder {
        private static final EvernoteApi INSTANCE = new EvernoteApi();

        private InstanceHolder() {
        }
    }
}

