/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.oauth;

import com.github.scribejava.core.builder.api.DefaultApi10a;
import com.github.scribejava.core.model.AbstractRequest;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.OAuthConstants;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.OAuthRequestAsync;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Token;
import com.github.scribejava.core.model.Verifier;
import com.github.scribejava.core.oauth.OAuthService;
import com.github.scribejava.core.services.Base64Encoder;
import com.github.scribejava.core.utils.MapUtils;
import com.ning.http.client.ProxyServer;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Future;

public class OAuth10aService
extends OAuthService {
    private static final String VERSION = "1.0";
    private final DefaultApi10a api;

    public OAuth10aService(DefaultApi10a api, OAuthConfig config) {
        super(config);
        this.api = api;
    }

    public Token getRequestToken() {
        OAuthConfig config = this.getConfig();
        config.log("obtaining request token from " + this.api.getRequestTokenEndpoint());
        OAuthRequest request = new OAuthRequest(this.api.getRequestTokenVerb(), this.api.getRequestTokenEndpoint(), this);
        config.log("setting oauth_callback to " + config.getCallback());
        request.addOAuthParameter("oauth_callback", config.getCallback());
        this.addOAuthParams(request, OAuthConstants.EMPTY_TOKEN);
        this.appendSignature(request);
        config.log("sending request...");
        Response response = request.send();
        String body = response.getBody();
        config.log("response status code: " + response.getCode());
        config.log("response body: " + body);
        return this.api.getRequestTokenExtractor().extract(body);
    }

    private void addOAuthParams(AbstractRequest request, Token token) {
        OAuthConfig config = this.getConfig();
        request.addOAuthParameter("oauth_timestamp", this.api.getTimestampService().getTimestampInSeconds());
        request.addOAuthParameter("oauth_nonce", this.api.getTimestampService().getNonce());
        request.addOAuthParameter("oauth_consumer_key", config.getApiKey());
        request.addOAuthParameter("oauth_signature_method", this.api.getSignatureService().getSignatureMethod());
        request.addOAuthParameter("oauth_version", this.getVersion());
        if (config.hasScope()) {
            request.addOAuthParameter("scope", config.getScope());
        }
        request.addOAuthParameter("oauth_signature", this.getSignature(request, token));
        config.log("appended additional OAuth parameters: " + MapUtils.toString(request.getOauthParameters()));
    }

    public final Token getAccessToken(Token requestToken, Verifier verifier) {
        OAuthConfig config = this.getConfig();
        config.log("obtaining access token from " + this.api.getAccessTokenEndpoint());
        OAuthRequest request = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint(), this);
        this.prepareAccessTokenRequest(request, requestToken, verifier);
        Response response = request.send();
        return this.api.getAccessTokenExtractor().extract(response.getBody());
    }

    public final Future<Token> getAccessTokenAsync(Token requestToken, Verifier verifier, OAuthAsyncRequestCallback<Token> callback) {
        return this.getAccessTokenAsync(requestToken, verifier, callback, null);
    }

    public final Future<Token> getAccessTokenAsync(Token requestToken, Verifier verifier, OAuthAsyncRequestCallback<Token> callback, ProxyServer proxyServer) {
        OAuthConfig config = this.getConfig();
        config.log("async obtaining access token from " + this.api.getAccessTokenEndpoint());
        OAuthRequestAsync request = new OAuthRequestAsync(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint(), this);
        this.prepareAccessTokenRequest(request, requestToken, verifier);
        return request.sendAsync(callback, new OAuthRequestAsync.ResponseConverter<Token>(){

            @Override
            public Token convert(com.ning.http.client.Response response) throws IOException {
                return OAuth10aService.this.getApi().getAccessTokenExtractor().extract(OAuthRequestAsync.RESPONSE_CONVERTER.convert(response).getBody());
            }
        }, proxyServer);
    }

    protected void prepareAccessTokenRequest(AbstractRequest request, Token requestToken, Verifier verifier) {
        OAuthConfig config = this.getConfig();
        request.addOAuthParameter("oauth_token", requestToken.getToken());
        request.addOAuthParameter("oauth_verifier", verifier.getValue());
        config.log("setting token to: " + requestToken + " and verifier to: " + verifier);
        this.addOAuthParams(request, requestToken);
        this.appendSignature(request);
    }

    @Override
    public void signRequest(Token token, AbstractRequest request) {
        OAuthConfig config = this.getConfig();
        config.log("signing request: " + request.getCompleteUrl());
        if (!token.isEmpty()) {
            request.addOAuthParameter("oauth_token", token.getToken());
        }
        config.log("setting token to: " + token);
        this.addOAuthParams(request, token);
        this.appendSignature(request);
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    public String getAuthorizationUrl(Token requestToken) {
        return this.api.getAuthorizationUrl(requestToken);
    }

    private String getSignature(AbstractRequest request, Token token) {
        OAuthConfig config = this.getConfig();
        config.log("generating signature...");
        config.log("using base64 encoder: " + Base64Encoder.type());
        String baseString = this.api.getBaseStringExtractor().extract(request);
        String signature = this.api.getSignatureService().getSignature(baseString, config.getApiSecret(), token.getSecret());
        config.log("base string is: " + baseString);
        config.log("signature is: " + signature);
        return signature;
    }

    private void appendSignature(AbstractRequest request) {
        OAuthConfig config = this.getConfig();
        switch (config.getSignatureType()) {
            case Header: {
                config.log("using Http Header signature");
                String oauthHeader = this.api.getHeaderExtractor().extract(request);
                request.addHeader("Authorization", oauthHeader);
                break;
            }
            case QueryString: {
                config.log("using Querystring signature");
                for (Map.Entry<String, String> entry : request.getOauthParameters().entrySet()) {
                    request.addQuerystringParameter(entry.getKey(), entry.getValue());
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown new Signature Type '" + (Object)((Object)config.getSignatureType()) + "'.");
            }
        }
    }

    public DefaultApi10a getApi() {
        return this.api;
    }
}

