/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.oauth;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.AbstractRequest;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.OAuthRequestAsync;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verifier;
import com.github.scribejava.core.oauth.OAuthService;
import com.ning.http.client.ProxyServer;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Future;

public class OAuth20Service
extends OAuthService {
    private static final String VERSION = "2.0";
    private final DefaultApi20 api;

    public OAuth20Service(DefaultApi20 api, OAuthConfig config) {
        super(config);
        this.api = api;
    }

    public final OAuth2AccessToken getAccessToken(Verifier verifier) {
        Response response = this.createAccessTokenRequest(verifier, new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint(), this)).send();
        return this.api.getAccessTokenExtractor().extract(response.getBody());
    }

    public final Future<OAuth2AccessToken> getAccessTokenAsync(Verifier verifier, OAuthAsyncRequestCallback<OAuth2AccessToken> callback) {
        return this.getAccessTokenAsync(verifier, callback, null);
    }

    public final Future<OAuth2AccessToken> getAccessTokenAsync(Verifier verifier, OAuthAsyncRequestCallback<OAuth2AccessToken> callback, ProxyServer proxyServer) {
        OAuthRequestAsync request = this.createAccessTokenRequest(verifier, new OAuthRequestAsync(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint(), this));
        return request.sendAsync(callback, new OAuthRequestAsync.ResponseConverter<OAuth2AccessToken>(){

            @Override
            public OAuth2AccessToken convert(com.ning.http.client.Response response) throws IOException {
                return OAuth20Service.this.getApi().getAccessTokenExtractor().extract(OAuthRequestAsync.RESPONSE_CONVERTER.convert(response).getBody());
            }
        }, proxyServer);
    }

    protected <T extends AbstractRequest> T createAccessTokenRequest(Verifier verifier, T request) {
        OAuthConfig config = this.getConfig();
        request.addParameter("client_id", config.getApiKey());
        request.addParameter("client_secret", config.getApiSecret());
        request.addParameter("code", verifier.getValue());
        request.addParameter("redirect_uri", config.getCallback());
        if (config.hasScope()) {
            request.addParameter("scope", config.getScope());
        }
        if (config.hasGrantType()) {
            request.addParameter("grant_type", config.getGrantType());
        }
        return request;
    }

    public final OAuth2AccessToken refreshAccessToken(String refreshToken) {
        Response response = this.createRefreshTokenRequest(refreshToken, new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint(), this)).send();
        return this.api.getAccessTokenExtractor().extract(response.getBody());
    }

    public final Future<OAuth2AccessToken> refreshAccessTokenAsync(String refreshToken, OAuthAsyncRequestCallback<OAuth2AccessToken> callback) {
        return this.refreshAccessTokenAsync(refreshToken, callback, null);
    }

    public final Future<OAuth2AccessToken> refreshAccessTokenAsync(String refreshToken, OAuthAsyncRequestCallback<OAuth2AccessToken> callback, ProxyServer proxyServer) {
        OAuthRequestAsync request = this.createRefreshTokenRequest(refreshToken, new OAuthRequestAsync(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint(), this));
        return request.sendAsync(callback, new OAuthRequestAsync.ResponseConverter<OAuth2AccessToken>(){

            @Override
            public OAuth2AccessToken convert(com.ning.http.client.Response response) throws IOException {
                return OAuth20Service.this.getApi().getAccessTokenExtractor().extract(OAuthRequestAsync.RESPONSE_CONVERTER.convert(response).getBody());
            }
        }, proxyServer);
    }

    protected <T extends AbstractRequest> T createRefreshTokenRequest(String refreshToken, T request) {
        if (refreshToken == null || refreshToken.isEmpty()) {
            throw new IllegalArgumentException("The refreshToken cannot be null or empty");
        }
        OAuthConfig config = this.getConfig();
        request.addParameter("client_id", config.getApiKey());
        request.addParameter("client_secret", config.getApiSecret());
        request.addParameter("refresh_token", refreshToken);
        request.addParameter("grant_type", "refresh_token");
        return request;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    public void signRequest(OAuth2AccessToken accessToken, AbstractRequest request) {
        request.addQuerystringParameter("access_token", accessToken.getAccessToken());
    }

    public final String getAuthorizationUrl() {
        return this.getAuthorizationUrl(null);
    }

    public String getAuthorizationUrl(Map<String, String> additionalParams) {
        return this.api.getAuthorizationUrl(this.getConfig(), additionalParams);
    }

    public DefaultApi20 getApi() {
        return this.api;
    }
}

