/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.builder.api;

import com.github.scribejava.core.builder.api.BaseApi;
import com.github.scribejava.core.extractors.OAuth2AccessTokenJsonExtractor;
import com.github.scribejava.core.extractors.TokenExtractor;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.github.scribejava.core.utils.OAuthEncoder;
import java.util.Map;

public abstract class DefaultApi20
implements BaseApi<OAuth20Service> {
    public TokenExtractor<OAuth2AccessToken> getAccessTokenExtractor() {
        return OAuth2AccessTokenJsonExtractor.instance();
    }

    public Verb getAccessTokenVerb() {
        return Verb.POST;
    }

    public abstract String getAccessTokenEndpoint();

    public String getRefreshTokenEndpoint() {
        return this.getAccessTokenEndpoint();
    }

    public abstract String getAuthorizationUrl(OAuthConfig var1);

    public String getAuthorizationUrl(OAuthConfig config, Map<String, String> additionalParams) {
        String authUrl = this.getAuthorizationUrl(config);
        if (additionalParams != null && !additionalParams.isEmpty()) {
            StringBuilder authUrlWithParams = new StringBuilder(authUrl).append(authUrl.indexOf(63) == -1 ? (char)'?' : '&');
            for (Map.Entry<String, String> param : additionalParams.entrySet()) {
                authUrlWithParams.append(OAuthEncoder.encode(param.getKey())).append('=').append(OAuthEncoder.encode(param.getValue())).append('&');
            }
            authUrl = authUrlWithParams.substring(0, authUrlWithParams.length() - 1);
        }
        return authUrl;
    }

    @Override
    public OAuth20Service createService(OAuthConfig config) {
        return new OAuth20Service(this, config);
    }
}

