/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.oauth;

import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.httpclient.HttpClientProvider;
import com.github.scribejava.core.model.ForceTypeOfHttpRequest;
import com.github.scribejava.core.model.HttpClient;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.OAuthRequestAsync;
import com.github.scribejava.core.model.ScribeJavaConfig;
import com.github.scribejava.core.model.Verb;
import java.io.IOException;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.Future;

public abstract class OAuthService {
    private final OAuthConfig config;
    private final HttpClient httpClient;

    public OAuthService(OAuthConfig config) {
        this.config = config;
        ForceTypeOfHttpRequest forceTypeOfHttpRequest = ScribeJavaConfig.getForceTypeOfHttpRequests();
        HttpClient.Config httpClientConfig = config.getHttpClientConfig();
        HttpClient externalHttpClient = config.getHttpClient();
        if (httpClientConfig == null && externalHttpClient == null) {
            if (ForceTypeOfHttpRequest.FORCE_ASYNC_ONLY_HTTP_REQUESTS == forceTypeOfHttpRequest) {
                throw new OAuthException("Cannot use sync operations, only async");
            }
            if (ForceTypeOfHttpRequest.PREFER_ASYNC_ONLY_HTTP_REQUESTS == forceTypeOfHttpRequest) {
                config.log("Cannot use sync operations, only async");
            }
            this.httpClient = null;
        } else {
            if (ForceTypeOfHttpRequest.FORCE_SYNC_ONLY_HTTP_REQUESTS == forceTypeOfHttpRequest) {
                throw new OAuthException("Cannot use async operations, only sync");
            }
            if (ForceTypeOfHttpRequest.PREFER_SYNC_ONLY_HTTP_REQUESTS == forceTypeOfHttpRequest) {
                config.log("Cannot use async operations, only sync");
            }
            this.httpClient = externalHttpClient == null ? OAuthService.getClient(httpClientConfig) : externalHttpClient;
        }
    }

    private static HttpClient getClient(HttpClient.Config config) {
        for (HttpClientProvider provider : ServiceLoader.load(HttpClientProvider.class)) {
            HttpClient client = provider.createClient(config);
            if (client == null) continue;
            return client;
        }
        return null;
    }

    public void closeAsyncClient() throws IOException {
        this.httpClient.close();
    }

    public OAuthConfig getConfig() {
        return this.config;
    }

    public abstract String getVersion();

    public <T> Future<T> executeAsync(Map<String, String> headers, Verb httpVerb, String completeUrl, String bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequestAsync.ResponseConverter<T> converter) {
        return this.httpClient.executeAsync(this.config.getUserAgent(), headers, httpVerb, completeUrl, bodyContents, callback, converter);
    }
}

