/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.builder;

import com.github.scribejava.core.builder.api.BaseApi;
import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.httpclient.HttpClientConfig;
import com.github.scribejava.core.model.HttpClient;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.SignatureType;
import com.github.scribejava.core.oauth.OAuthService;
import com.github.scribejava.core.utils.Preconditions;
import java.io.OutputStream;

public class ServiceBuilder {
    private String callback = "oob";
    private String apiKey;
    private String apiSecret;
    private String scope;
    private String state;
    private SignatureType signatureType = SignatureType.Header;
    private OutputStream debugStream;
    private String responseType = "code";
    private String userAgent;
    private Integer connectTimeout;
    private Integer readTimeout;
    private HttpClientConfig httpClientConfig;
    private HttpClient httpClient;

    public ServiceBuilder callback(String callback) {
        Preconditions.checkNotNull(callback, "Callback can't be null");
        this.callback = callback;
        return this;
    }

    public ServiceBuilder apiKey(String apiKey) {
        Preconditions.checkEmptyString(apiKey, "Invalid Api key");
        this.apiKey = apiKey;
        return this;
    }

    public ServiceBuilder apiSecret(String apiSecret) {
        Preconditions.checkEmptyString(apiSecret, "Invalid Api secret");
        this.apiSecret = apiSecret;
        return this;
    }

    public ServiceBuilder scope(String scope) {
        Preconditions.checkEmptyString(scope, "Invalid OAuth scope");
        this.scope = scope;
        return this;
    }

    public ServiceBuilder state(String state) {
        Preconditions.checkEmptyString(state, "Invalid OAuth state");
        this.state = state;
        return this;
    }

    public ServiceBuilder signatureType(SignatureType signatureType) {
        Preconditions.checkNotNull((Object)signatureType, "Signature type can't be null");
        this.signatureType = signatureType;
        return this;
    }

    public ServiceBuilder debugStream(OutputStream debugStream) {
        Preconditions.checkNotNull(debugStream, "debug stream can't be null");
        this.debugStream = debugStream;
        return this;
    }

    public ServiceBuilder responseType(String responseType) {
        Preconditions.checkEmptyString(responseType, "Invalid OAuth responseType");
        this.responseType = responseType;
        return this;
    }

    public ServiceBuilder connectTimeout(Integer connectTimeout) {
        Preconditions.checkNotNull(connectTimeout, "Connection timeout can't be null");
        this.connectTimeout = connectTimeout;
        return this;
    }

    public ServiceBuilder readTimeout(Integer readTimeout) {
        Preconditions.checkNotNull(readTimeout, "Read timeout can't be null");
        this.readTimeout = readTimeout;
        return this;
    }

    @Deprecated
    public ServiceBuilder httpClientConfig(HttpClient.Config httpClientConfig) {
        throw new UnsupportedOperationException("deprecated, use another method, see javadocs");
    }

    public ServiceBuilder httpClientConfig(HttpClientConfig httpClientConfig) {
        Preconditions.checkNotNull(httpClientConfig, "httpClientConfig can't be null");
        this.httpClientConfig = httpClientConfig;
        return this;
    }

    public ServiceBuilder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public ServiceBuilder userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public ServiceBuilder debug() {
        this.debugStream(System.out);
        return this;
    }

    public void checkPreconditions() {
        Preconditions.checkEmptyString(this.apiKey, "You must provide an api key");
    }

    private OAuthConfig createConfig() {
        this.checkPreconditions();
        return new OAuthConfig(this.apiKey, this.apiSecret, this.callback, this.signatureType, this.scope, this.debugStream, this.state, this.responseType, this.userAgent, this.connectTimeout, this.readTimeout, this.httpClientConfig, this.httpClient);
    }

    public <S extends OAuthService<?>> S build(BaseApi<S> api) {
        return api.createService(this.createConfig());
    }
}

