/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.oauth;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.AbstractRequest;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuth2Authorization;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.OAuthRequestAsync;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.oauth.OAuthService;
import com.github.scribejava.core.services.Base64Encoder;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.Future;

public class OAuth20Service
extends OAuthService<OAuth2AccessToken> {
    private static final String VERSION = "2.0";
    private final DefaultApi20 api;

    public OAuth20Service(DefaultApi20 api, OAuthConfig config) {
        super(config);
        this.api = api;
    }

    protected OAuth2AccessToken sendAccessTokenRequestSync(OAuthRequest request) throws IOException {
        return this.api.getAccessTokenExtractor().extract(request.send());
    }

    protected Future<OAuth2AccessToken> sendAccessTokenRequestAsync(OAuthRequestAsync request, OAuthAsyncRequestCallback<OAuth2AccessToken> callback) {
        return this.execute(request, callback, new OAuthRequestAsync.ResponseConverter<OAuth2AccessToken>(){

            @Override
            public OAuth2AccessToken convert(Response response) throws IOException {
                return OAuth20Service.this.getApi().getAccessTokenExtractor().extract(response);
            }
        });
    }

    public final OAuth2AccessToken getAccessToken(String code) throws IOException {
        OAuthRequest request = this.createAccessTokenRequest(code, new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint(), this.getConfig()));
        return this.sendAccessTokenRequestSync(request);
    }

    public final Future<OAuth2AccessToken> getAccessTokenAsync(String code, OAuthAsyncRequestCallback<OAuth2AccessToken> callback) {
        OAuthRequestAsync request = this.createAccessTokenRequest(code, new OAuthRequestAsync(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint()));
        return this.sendAccessTokenRequestAsync(request, callback);
    }

    protected <T extends AbstractRequest> T createAccessTokenRequest(String code, T request) {
        OAuthConfig config = this.getConfig();
        request.addParameter("client_id", config.getApiKey());
        request.addParameter("client_secret", config.getApiSecret());
        request.addParameter("code", code);
        request.addParameter("redirect_uri", config.getCallback());
        String scope = config.getScope();
        if (scope != null) {
            request.addParameter("scope", scope);
        }
        request.addParameter("grant_type", "authorization_code");
        return request;
    }

    public final OAuth2AccessToken refreshAccessToken(String refreshToken) throws IOException {
        OAuthRequest request = this.createRefreshTokenRequest(refreshToken, new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getRefreshTokenEndpoint(), this.getConfig()));
        return this.sendAccessTokenRequestSync(request);
    }

    public final Future<OAuth2AccessToken> refreshAccessTokenAsync(String refreshToken, OAuthAsyncRequestCallback<OAuth2AccessToken> callback) {
        OAuthRequestAsync request = this.createRefreshTokenRequest(refreshToken, new OAuthRequestAsync(this.api.getAccessTokenVerb(), this.api.getRefreshTokenEndpoint()));
        return this.sendAccessTokenRequestAsync(request, callback);
    }

    protected <T extends AbstractRequest> T createRefreshTokenRequest(String refreshToken, T request) {
        if (refreshToken == null || refreshToken.isEmpty()) {
            throw new IllegalArgumentException("The refreshToken cannot be null or empty");
        }
        OAuthConfig config = this.getConfig();
        request.addParameter("client_id", config.getApiKey());
        request.addParameter("client_secret", config.getApiSecret());
        request.addParameter("refresh_token", refreshToken);
        request.addParameter("grant_type", "refresh_token");
        return request;
    }

    public final OAuth2AccessToken getAccessTokenPasswordGrant(String uname, String password) throws IOException {
        OAuthRequest request = this.createAccessTokenPasswordGrantRequest(uname, password, new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint(), this.getConfig()));
        return this.sendAccessTokenRequestSync(request);
    }

    public final Future<OAuth2AccessToken> getAccessTokenPasswordGrantAsync(String uname, String password, OAuthAsyncRequestCallback<OAuth2AccessToken> callback) {
        OAuthRequestAsync request = this.createAccessTokenPasswordGrantRequest(uname, password, new OAuthRequestAsync(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint()));
        return this.sendAccessTokenRequestAsync(request, callback);
    }

    protected <T extends AbstractRequest> T createAccessTokenPasswordGrantRequest(String username, String password, T request) {
        OAuthConfig config = this.getConfig();
        request.addParameter("username", username);
        request.addParameter("password", password);
        String scope = config.getScope();
        if (scope != null) {
            request.addParameter("scope", scope);
        }
        request.addParameter("grant_type", "password");
        String apiKey = config.getApiKey();
        String apiSecret = config.getApiSecret();
        if (apiKey != null && apiSecret != null) {
            request.addHeader("Authorization", "Basic " + Base64Encoder.getInstance().encode(String.format("%s:%s", apiKey, apiSecret).getBytes(Charset.forName("UTF-8"))));
        }
        return request;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public void signRequest(OAuth2AccessToken accessToken, AbstractRequest request) {
        request.addQuerystringParameter("access_token", accessToken.getAccessToken());
    }

    public final String getAuthorizationUrl() {
        return this.getAuthorizationUrl(null);
    }

    public String getAuthorizationUrl(Map<String, String> additionalParams) {
        return this.api.getAuthorizationUrl(this.getConfig(), additionalParams);
    }

    public DefaultApi20 getApi() {
        return this.api;
    }

    public OAuth2Authorization extractAuthorization(String redirectLocation) {
        OAuth2Authorization authorization = new OAuth2Authorization();
        block8: for (String param : redirectLocation.substring(redirectLocation.indexOf(63) + 1).split("&")) {
            String[] keyValue = param.split("=");
            if (keyValue.length != 2) continue;
            switch (keyValue[0]) {
                case "code": {
                    authorization.setCode(keyValue[1]);
                    continue block8;
                }
                case "state": {
                    authorization.setState(keyValue[1]);
                    continue block8;
                }
            }
        }
        return authorization;
    }
}

