/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.model;

import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.oauth2.OAuth2Error;
import java.net.URI;

public class OAuth2AccessTokenErrorResponse
extends OAuthException {
    private static final long serialVersionUID = 2309424849700276816L;
    private final ErrorCode errorCode;
    private final OAuth2Error error;
    private final String errorDescription;
    private final URI errorUri;
    private final String rawResponse;

    @Deprecated
    public OAuth2AccessTokenErrorResponse(ErrorCode errorCode, String errorDescription, URI errorUri, String rawResponse) {
        super(rawResponse);
        this.errorCode = errorCode;
        this.error = OAuth2Error.parseFrom(errorCode.errorCodeString);
        this.errorDescription = errorDescription;
        this.errorUri = errorUri;
        this.rawResponse = rawResponse;
    }

    public OAuth2AccessTokenErrorResponse(OAuth2Error error, String errorDescription, URI errorUri, String rawResponse) {
        super(rawResponse);
        ErrorCode oldErrorCode;
        try {
            oldErrorCode = ErrorCode.parseFrom(error.getErrorString());
        }
        catch (IllegalArgumentException iaE) {
            oldErrorCode = null;
        }
        this.errorCode = oldErrorCode;
        this.error = error;
        this.errorDescription = errorDescription;
        this.errorUri = errorUri;
        this.rawResponse = rawResponse;
    }

    public OAuth2Error getError() {
        return this.error;
    }

    @Deprecated
    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public URI getErrorUri() {
        return this.errorUri;
    }

    public String getRawResponse() {
        return this.rawResponse;
    }

    @Deprecated
    public static enum ErrorCode {
        INVALID_REQUEST("invalid_request"),
        INVALID_CLIENT("invalid_client"),
        INVALID_GRANT("invalid_grant"),
        UNAUTHORIZED_CLIENT("unauthorized_client"),
        UNSUPPORTED_GRANT_TYPE("unsupported_grant_type"),
        INVALID_SCOPE("invalid_scope"),
        UNSUPPORTED_TOKEN_TYPE("unsupported_token_type");

        private final String errorCodeString;

        private ErrorCode(String errorCodeString) {
            this.errorCodeString = errorCodeString;
        }

        public static ErrorCode parseFrom(String errorCodeString) {
            for (ErrorCode errorCode : ErrorCode.values()) {
                if (!errorCode.errorCodeString.equals(errorCodeString)) continue;
                return errorCode;
            }
            throw new IllegalArgumentException("there is no knowlege about '" + errorCodeString + "' ErrorCode");
        }
    }
}

