/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.oauth;

import com.github.scribejava.core.oauth.OAuth20Service;
import com.github.scribejava.core.pkce.PKCE;
import com.github.scribejava.core.pkce.PKCEService;
import java.util.HashMap;
import java.util.Map;

public class AuthorizationUrlBuilder {
    private final OAuth20Service oauth20Service;
    private String state;
    private Map<String, String> additionalParams;
    private PKCE pkce;
    private String scope;

    public AuthorizationUrlBuilder(OAuth20Service oauth20Service) {
        this.oauth20Service = oauth20Service;
    }

    public AuthorizationUrlBuilder state(String state) {
        this.state = state;
        return this;
    }

    public AuthorizationUrlBuilder additionalParams(Map<String, String> additionalParams) {
        this.additionalParams = additionalParams;
        return this;
    }

    public AuthorizationUrlBuilder pkce(PKCE pkce) {
        this.pkce = pkce;
        return this;
    }

    public AuthorizationUrlBuilder initPKCE() {
        this.pkce = PKCEService.defaultInstance().generatePKCE();
        return this;
    }

    public AuthorizationUrlBuilder scope(String scope) {
        this.scope = scope;
        return this;
    }

    public PKCE getPkce() {
        return this.pkce;
    }

    public String build() {
        Map<String, String> params;
        if (this.pkce == null) {
            params = this.additionalParams;
        } else {
            params = this.additionalParams == null ? new HashMap<String, String>() : new HashMap<String, String>(this.additionalParams);
            params.putAll(this.pkce.getAuthorizationUrlParams());
        }
        return this.oauth20Service.getApi().getAuthorizationUrl(this.oauth20Service.getResponseType(), this.oauth20Service.getApiKey(), this.oauth20Service.getCallback(), this.scope == null ? this.oauth20Service.getDefaultScope() : this.scope, this.state, params);
    }
}

