/*
 * Decompiled with CFR 0.152.
 */
package com.github.thomasridd.flatsy.query.matchers;

import com.github.thomasridd.flatsy.FlatsyObject;
import com.github.thomasridd.flatsy.FlatsyObjectType;
import com.github.thomasridd.flatsy.query.matchers.FlatsyMatcher;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelValidXLSX
implements FlatsyMatcher {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean matches(FlatsyObject object) {
        if (object.getType() == FlatsyObjectType.Folder) {
            return false;
        }
        try (InputStream stream = object.retrieveStream();){
            if (ExcelValidXLSX.isXLSXValid(stream)) return true;
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isXLSXValid(InputStream stream) {
        try {
            XSSFWorkbook workbook = new XSSFWorkbook(stream);
            workbook.getSheetAt(0);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

