/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.helper;

import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.processing.EBeansHolder;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

public class APTCodeModelHelper {
    public JClass typeMirrorToJClass(TypeMirror type, EBeanHolder holder) {
        if (type instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)type;
            String declaredTypeName = declaredType.asElement().toString();
            JClass declaredClass = holder.refClass(declaredTypeName);
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            ArrayList<JClass> typeArgumentJClasses = new ArrayList<JClass>();
            for (TypeMirror typeMirror : typeArguments) {
                typeArgumentJClasses.add(this.typeMirrorToJClass(typeMirror, holder));
            }
            if (typeArgumentJClasses.size() > 0) {
                declaredClass = declaredClass.narrow(typeArgumentJClasses);
            }
            return declaredClass;
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            JClass refClass = this.typeMirrorToJClass(arrayType.getComponentType(), holder);
            return refClass.array();
        }
        return holder.refClass(((Object)type).toString());
    }

    public JMethod overrideAnnotatedMethod(ExecutableElement executableElement, EBeanHolder holder) {
        String methodName = executableElement.getSimpleName().toString();
        JClass returnType = this.typeMirrorToJClass(executableElement.getReturnType(), holder);
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (VariableElement variableElement : executableElement.getParameters()) {
            String parameterName = variableElement.getSimpleName().toString();
            JClass parameterClass = this.typeMirrorToJClass(variableElement.asType(), holder);
            parameters.add(new Parameter(parameterName, parameterClass));
        }
        JMethod existingMethod = this.findAlreadyGeneratedMethod(holder.generatedClass, methodName, parameters);
        if (existingMethod != null) {
            return existingMethod;
        }
        JMethod jMethod = holder.generatedClass.method(1, returnType, methodName);
        jMethod.annotate(Override.class);
        ArrayList<JVar> methodParameters = new ArrayList<JVar>();
        for (VariableElement variableElement : executableElement.getParameters()) {
            String parameterName = variableElement.getSimpleName().toString();
            JClass parameterClass = this.typeMirrorToJClass(variableElement.asType(), holder);
            JVar param = jMethod.param(8, parameterClass, parameterName);
            methodParameters.add(param);
        }
        for (TypeMirror typeMirror : executableElement.getThrownTypes()) {
            JClass thrownType = this.typeMirrorToJClass(typeMirror, holder);
            jMethod._throws(thrownType);
        }
        this.callSuperMethod(jMethod, holder, jMethod.body());
        return jMethod;
    }

    private JMethod findAlreadyGeneratedMethod(JDefinedClass definedClass, String methodName, List<Parameter> parameters) {
        block0: for (JMethod method : definedClass.methods()) {
            if (!method.name().equals(methodName) || method.params().size() != parameters.size()) continue;
            int i = 0;
            for (JVar param : method.params()) {
                String searchedParamType = parameters.get((int)i).jClass.name();
                if (!param.type().name().equals(searchedParamType)) continue block0;
                ++i;
            }
            return method;
        }
        return null;
    }

    public void callSuperMethod(JMethod superMethod, EBeanHolder holder, JBlock callBlock) {
        JFieldRef activitySuper = holder.generatedClass.staticRef("super");
        JInvocation superCall = JExpr.invoke((JExpression)activitySuper, superMethod);
        for (JVar param : superMethod.params()) {
            superCall.arg(param);
        }
        JType returnType = superMethod.type();
        if (returnType.fullName().equals("void")) {
            callBlock.add(superCall);
        } else {
            callBlock._return(superCall);
        }
    }

    public JBlock removeBody(JMethod method) {
        JBlock body = method.body();
        try {
            Field bodyField = JMethod.class.getDeclaredField("body");
            bodyField.setAccessible(true);
            bodyField.set(method, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        JBlock clonedBody = new JBlock(false, false);
        for (Object statement : body.getContents()) {
            clonedBody.add((JStatement)statement);
        }
        return clonedBody;
    }

    public String getIdStringFromIdFieldRef(JFieldRef idRef) {
        try {
            Field nameField = JFieldRef.class.getDeclaredField("name");
            nameField.setAccessible(true);
            String name = (String)nameField.get(idRef);
            if (name != null) {
                return name;
            }
            Field varField = JFieldRef.class.getDeclaredField("var");
            varField.setAccessible(true);
            JVar var = (JVar)varField.get(idRef);
            if (var != null) {
                return var.name();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new IllegalStateException("Unable to extract target name from JFieldRef");
    }

    public JDefinedClass createDelegatingAnonymousRunnableClass(EBeanHolder holder, JMethod delegatedMethod) {
        JCodeModel codeModel = holder.codeModel();
        EBeansHolder.Classes classes = holder.classes();
        JBlock previousMethodBody = this.removeBody(delegatedMethod);
        JDefinedClass anonymousRunnableClass = codeModel.anonymousClass(Runnable.class);
        JMethod runMethod = anonymousRunnableClass.method(1, codeModel.VOID, "run");
        runMethod.annotate(Override.class);
        JBlock runMethodBody = runMethod.body();
        JTryBlock runTry = runMethodBody._try();
        runTry.body().add(previousMethodBody);
        JCatchBlock runCatch = runTry._catch(classes.RUNTIME_EXCEPTION);
        JVar exceptionParam = runCatch.param("e");
        JInvocation errorInvoke = classes.LOG.staticInvoke("e");
        errorInvoke.arg(holder.generatedClass.name());
        errorInvoke.arg("A runtime exception was thrown while executing code in a runnable");
        errorInvoke.arg(exceptionParam);
        runCatch.body().add(errorInvoke);
        return anonymousRunnableClass;
    }

    public JVar castContextToActivity(EBeanHolder holder, JBlock ifActivityBody) {
        JClass activityClass = holder.classes().ACTIVITY;
        return ifActivityBody.decl(activityClass, "activity", JExpr.cast(activityClass, holder.contextRef));
    }

    public JBlock ifContextInstanceOfActivity(EBeanHolder holder, JBlock methodBody) {
        return methodBody._if(holder.contextRef._instanceof(holder.classes().ACTIVITY))._then();
    }

    public void copyConstructorsAndAddStaticEViewBuilders(Element element, JCodeModel codeModel, JClass eBeanClass, EBeanHolder holder, JMethod setContentViewMethod) {
        ArrayList<ExecutableElement> constructors = new ArrayList<ExecutableElement>();
        for (Element element2 : element.getEnclosedElements()) {
            if (element2.getKind() != ElementKind.CONSTRUCTOR) continue;
            constructors.add((ExecutableElement)element2);
        }
        for (ExecutableElement executableElement : constructors) {
            JMethod copyConstructor = holder.generatedClass.constructor(1);
            JMethod staticHelper = holder.generatedClass.method(17, eBeanClass, "build");
            JBlock body = copyConstructor.body();
            JInvocation superCall = body.invoke("super");
            JInvocation newInvocation = JExpr._new(holder.generatedClass);
            for (VariableElement variableElement : executableElement.getParameters()) {
                String paramName = variableElement.getSimpleName().toString();
                String paramType = ((Object)variableElement.asType()).toString();
                copyConstructor.param(holder.refClass(paramType), paramName);
                staticHelper.param(holder.refClass(paramType), paramName);
                superCall.arg(JExpr.ref(paramName));
                newInvocation.arg(JExpr.ref(paramName));
            }
            JVar newCall = staticHelper.body().decl(holder.generatedClass, "instance", newInvocation);
            staticHelper.body().invoke((JExpression)newCall, "onFinishInflate");
            staticHelper.body()._return(newCall);
            body.invoke(holder.init);
        }
    }

    public JVar findParameterByName(JMethod method, String name) {
        for (JVar parameter : method.params()) {
            if (!parameter.name().equals(name)) continue;
            return parameter;
        }
        return null;
    }

    public void addActivityIntentBuilder(JCodeModel codeModel, EBeanHolder holder) throws Exception {
        this.addIntentBuilder(codeModel, holder, true);
    }

    public void addServiceIntentBuilder(JCodeModel codeModel, EBeanHolder holder) throws Exception {
        this.addIntentBuilder(codeModel, holder, false);
    }

    private void addIntentBuilder(JCodeModel codeModel, EBeanHolder holder, boolean isActivity) throws JClassAlreadyExistsException {
        JClass contextClass = holder.classes().CONTEXT;
        JClass intentClass = holder.classes().INTENT;
        holder.intentBuilderClass = holder.generatedClass._class(17, "IntentBuilder_");
        JFieldVar contextField = holder.intentBuilderClass.field(4, contextClass, "context_");
        holder.intentField = holder.intentBuilderClass.field(12, intentClass, "intent_");
        JMethod constructor = holder.intentBuilderClass.constructor(1);
        JVar constructorContextParam = constructor.param(contextClass, "context");
        JBlock constructorBody = constructor.body();
        constructorBody.assign(contextField, constructorContextParam);
        constructorBody.assign(holder.intentField, JExpr._new(intentClass).arg(constructorContextParam).arg(holder.generatedClass.dotclass()));
        JMethod method = holder.intentBuilderClass.method(1, intentClass, "get");
        method.body()._return(holder.intentField);
        method = holder.intentBuilderClass.method(1, holder.intentBuilderClass, "flags");
        JVar flagsParam = method.param(codeModel.INT, "flags");
        JBlock body = method.body();
        body.invoke((JExpression)holder.intentField, "setFlags").arg(flagsParam);
        body._return(JExpr._this());
        method = holder.intentBuilderClass.method(1, codeModel.VOID, "start");
        String startComponentName = isActivity ? "startActivity" : "startService";
        method.body().invoke((JExpression)contextField, startComponentName).arg(holder.intentField);
        if (isActivity) {
            method = holder.intentBuilderClass.method(1, codeModel.VOID, "startForResult");
            JVar requestCode = method.param(codeModel.INT, "requestCode");
            body = method.body();
            JClass activityClass = holder.classes().ACTIVITY;
            JConditional condition = body._if(contextField._instanceof(activityClass));
            condition._then().invoke((JExpression)JExpr.cast(activityClass, contextField), "startActivityForResult").arg(holder.intentField).arg(requestCode);
            condition._else().invoke((JExpression)contextField, "startActivity").arg(holder.intentField);
        }
        method = holder.generatedClass.method(17, holder.intentBuilderClass, "intent");
        JVar contextParam = method.param(contextClass, "context");
        method.body()._return(JExpr._new(holder.intentBuilderClass).arg(contextParam));
    }

    public static class Parameter {
        public final String name;
        public final JClass jClass;

        public Parameter(String name, JClass jClass) {
            this.name = name;
            this.jClass = jClass;
        }
    }
}

