/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.EActivity;
import com.googlecode.androidannotations.api.SdkVersionHelper;
import com.googlecode.androidannotations.helper.APTCodeModelHelper;
import com.googlecode.androidannotations.helper.AnnotationHelper;
import com.googlecode.androidannotations.helper.GreenDroidConstants;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.processing.EBeansHolder;
import com.googlecode.androidannotations.processing.GeneratingElementProcessor;
import com.googlecode.androidannotations.rclass.IRClass;
import com.sun.codemodel.ClassType;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;

public class EActivityProcessor
implements GeneratingElementProcessor {
    private final IRClass rClass;
    private List<TypeElement> greendroidActivityElements;
    private final AnnotationHelper annotationHelper;
    private final ProcessingEnvironment processingEnv;
    private final APTCodeModelHelper aptCodeModelHelper;

    public EActivityProcessor(ProcessingEnvironment processingEnv, IRClass rClass) {
        this.processingEnv = processingEnv;
        this.annotationHelper = new AnnotationHelper(processingEnv);
        this.aptCodeModelHelper = new APTCodeModelHelper();
        this.rClass = rClass;
        this.greendroidActivityElements = new ArrayList<TypeElement>();
        for (String greendroidActivityName : GreenDroidConstants.GREENDROID_ACTIVITIES_LIST_CLASS) {
            TypeElement typeElement = this.annotationHelper.typeElementFromQualifiedName(greendroidActivityName);
            if (typeElement == null) continue;
            this.greendroidActivityElements.add(typeElement);
        }
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return EActivity.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeansHolder eBeansHolder) throws Exception {
        TypeElement typeElement = (TypeElement)element;
        String annotatedActivityQualifiedName = typeElement.getQualifiedName().toString();
        String subActivityQualifiedName = annotatedActivityQualifiedName + "_";
        boolean usesGreenDroid = this.usesGreenDroid(typeElement);
        int modifiers = 9;
        JDefinedClass generatedClass = codeModel._class(modifiers, subActivityQualifiedName, ClassType.CLASS);
        EBeanHolder holder = eBeansHolder.create(element, this.getTarget(), generatedClass);
        JClass annotatedActivity = codeModel.directClass(annotatedActivityQualifiedName);
        holder.generatedClass._extends(annotatedActivity);
        holder.contextRef = JExpr._this();
        JMethod onCreate = holder.generatedClass.method(1, codeModel.VOID, "onCreate");
        onCreate.annotate(Override.class);
        JClass bundleClass = holder.classes().BUNDLE;
        holder.init = holder.generatedClass.method(4, codeModel.VOID, "init_");
        holder.beforeCreateSavedInstanceStateParam = holder.init.param(bundleClass, "savedInstanceState");
        holder.initIfActivityBody = holder.init.body();
        holder.initActivityRef = JExpr._this();
        holder.afterSetContentView = holder.generatedClass.method(4, codeModel.VOID, "afterSetContentView_");
        JVar onCreateSavedInstanceState = onCreate.param(bundleClass, "savedInstanceState");
        JBlock onCreateBody = onCreate.body();
        onCreateBody.invoke(holder.init).arg(onCreateSavedInstanceState);
        onCreateBody.invoke(JExpr._super(), onCreate).arg(onCreateSavedInstanceState);
        List<JFieldRef> fieldRefs = this.annotationHelper.extractAnnotationFieldRefs(holder, element, EActivity.class, this.rClass.get(IRClass.Res.LAYOUT), false);
        JFieldRef contentViewId = fieldRefs.size() == 1 ? fieldRefs.get(0) : null;
        if (contentViewId != null) {
            if (usesGreenDroid) {
                onCreateBody.invoke("setActionBarContentView").arg(contentViewId);
            } else {
                onCreateBody.invoke("setContentView").arg(contentViewId);
            }
        }
        JClass layoutParamsClass = holder.classes().VIEW_GROUP_LAYOUT_PARAMS;
        String setContentViewMethodName = usesGreenDroid ? "setActionBarContentView" : "setContentView";
        this.setContentViewMethod(setContentViewMethodName, codeModel, holder, new JType[]{codeModel.INT}, new String[]{"layoutResID"});
        this.setContentViewMethod(setContentViewMethodName, codeModel, holder, new JType[]{holder.classes().VIEW, layoutParamsClass}, new String[]{"view", "params"});
        this.setContentViewMethod(setContentViewMethodName, codeModel, holder, new JType[]{holder.classes().VIEW}, new String[]{"view"});
        if (this.hasOnBackPressedMethod(typeElement)) {
            JMethod onKeyDownMethod = holder.generatedClass.method(1, codeModel.BOOLEAN, "onKeyDown");
            onKeyDownMethod.annotate(Override.class);
            JVar keyCodeParam = onKeyDownMethod.param(codeModel.INT, "keyCode");
            JClass keyEventClass = holder.classes().KEY_EVENT;
            JVar eventParam = onKeyDownMethod.param(keyEventClass, "event");
            JClass versionHelperClass = holder.refClass(SdkVersionHelper.class);
            JInvocation sdkInt = versionHelperClass.staticInvoke("getSdkInt");
            JBlock onKeyDownBody = onKeyDownMethod.body();
            onKeyDownBody._if(sdkInt.lt(JExpr.lit(5)).cand(keyCodeParam.eq(keyEventClass.staticRef("KEYCODE_BACK"))).cand(eventParam.invoke("getRepeatCount").eq(JExpr.lit(0))))._then().invoke("onBackPressed");
            onKeyDownBody._return(JExpr._super().invoke(onKeyDownMethod).arg(keyCodeParam).arg(eventParam));
        }
        this.aptCodeModelHelper.addActivityIntentBuilder(codeModel, holder);
    }

    private void setContentViewMethod(String setContentViewMethodName, JCodeModel codeModel, EBeanHolder holder, JType[] paramTypes, String[] paramNames) {
        JMethod method = holder.generatedClass.method(1, codeModel.VOID, setContentViewMethodName);
        method.annotate(Override.class);
        ArrayList<JVar> params = new ArrayList<JVar>();
        for (int i = 0; i < paramTypes.length; ++i) {
            JVar param = method.param(paramTypes[i], paramNames[i]);
            params.add(param);
        }
        JBlock body = method.body();
        JInvocation superCall = body.invoke(JExpr._super(), method);
        for (JVar arg : params) {
            superCall.arg(arg);
        }
        body.invoke(holder.afterSetContentView);
    }

    private boolean hasOnBackPressedMethod(TypeElement activityElement) {
        List<? extends Element> allMembers = this.annotationHelper.getElementUtils().getAllMembers(activityElement);
        List<ExecutableElement> activityInheritedMethods = ElementFilter.methodsIn(allMembers);
        for (ExecutableElement activityInheritedMethod : activityInheritedMethods) {
            if (!this.isCustomOnBackPressedMethod(activityInheritedMethod)) continue;
            return true;
        }
        return false;
    }

    private boolean isCustomOnBackPressedMethod(ExecutableElement method) {
        TypeElement methodClass = (TypeElement)method.getEnclosingElement();
        boolean methodBelongsToActivityClass = methodClass.getQualifiedName().toString().equals("android.app.Activity");
        return !methodBelongsToActivityClass && method.getSimpleName().toString().equals("onBackPressed") && method.getThrownTypes().size() == 0 && method.getModifiers().contains((Object)Modifier.PUBLIC) && method.getReturnType().getKind().equals((Object)TypeKind.VOID) && method.getParameters().size() == 0;
    }

    private boolean usesGreenDroid(TypeElement typeElement) {
        for (TypeElement greendroidActivityElement : this.greendroidActivityElements) {
            if (!this.processingEnv.getTypeUtils().isSubtype(typeElement.asType(), greendroidActivityElement.asType())) continue;
            return true;
        }
        return false;
    }
}

