/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing.rest;

import com.googlecode.androidannotations.annotations.rest.Post;
import com.googlecode.androidannotations.helper.CanonicalNameConstants;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.processing.rest.MethodProcessor;
import com.googlecode.androidannotations.processing.rest.MethodProcessorHolder;
import com.googlecode.androidannotations.processing.rest.RestImplementationsHolder;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class PostProcessor
extends MethodProcessor {
    private EBeanHolder holder;

    public PostProcessor(ProcessingEnvironment processingEnv, RestImplementationsHolder restImplementationHolder) {
        super(processingEnv, restImplementationHolder);
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return Post.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeanHolder holder) {
        this.holder = holder;
        ExecutableElement executableElement = (ExecutableElement)element;
        TypeMirror returnType = executableElement.getReturnType();
        JClass generatedReturnType = null;
        String returnTypeString = ((Object)returnType).toString();
        JClass expectedClass = null;
        if (returnType.getKind() != TypeKind.VOID) {
            TypeMirror typeParameter;
            DeclaredType declaredReturnedType;
            if (returnTypeString.startsWith(CanonicalNameConstants.URI)) {
                declaredReturnedType = (DeclaredType)returnType;
                typeParameter = declaredReturnedType.getTypeArguments().get(0);
                expectedClass = holder.refClass(((Object)typeParameter).toString());
                generatedReturnType = holder.refClass(CanonicalNameConstants.URI);
            } else if (returnTypeString.startsWith("org.springframework.http.ResponseEntity")) {
                declaredReturnedType = (DeclaredType)returnType;
                typeParameter = declaredReturnedType.getTypeArguments().get(0);
                expectedClass = holder.refClass(((Object)typeParameter).toString());
                generatedReturnType = holder.refClass("org.springframework.http.ResponseEntity").narrow(expectedClass);
            } else {
                expectedClass = generatedReturnType = holder.refClass(returnTypeString);
            }
        }
        Post postAnnotation = element.getAnnotation(Post.class);
        String urlSuffix = postAnnotation.value();
        this.generateRestTemplateCallBlock(new MethodProcessorHolder(holder, executableElement, urlSuffix, expectedClass, generatedReturnType, codeModel));
    }

    @Override
    protected JInvocation addHttpEntityVar(JInvocation restCall, MethodProcessorHolder methodHolder) {
        return restCall.arg(this.generateHttpEntityVar(methodHolder));
    }

    @Override
    protected JInvocation addResponseEntityArg(JInvocation restCall, MethodProcessorHolder methodHolder) {
        JClass expectedClass = methodHolder.getExpectedClass();
        if (expectedClass != null) {
            restCall.arg(expectedClass.dotclass());
        } else {
            restCall.arg(JExpr._null());
        }
        return restCall;
    }

    @Override
    protected JInvocation addResultCallMethod(JInvocation restCall, MethodProcessorHolder methodHolder) {
        JClass generatedReturnType;
        JClass expectedClass = methodHolder.getExpectedClass();
        if (expectedClass == (generatedReturnType = methodHolder.getGeneratedReturnType()) && expectedClass != null) {
            restCall = JExpr.invoke((JExpression)restCall, "getBody");
        }
        return restCall;
    }

    @Override
    protected JVar addHttpHeadersVar(JBlock body, ExecutableElement executableElement) {
        return this.generateHttpHeadersVar(this.holder, body, executableElement);
    }
}

