/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah.datastructure;

import java.util.Arrays;

public class StaticBitSet {
    long[] data;

    public StaticBitSet(int sizeinbits) {
        this.data = new long[(sizeinbits + 63) / 64];
    }

    public int size() {
        return this.data.length * 64;
    }

    public void resize(int sizeinbits) {
        this.data = Arrays.copyOf(this.data, (sizeinbits + 63) / 64);
    }

    public void clear() {
        Arrays.fill(this.data, 0L);
    }

    public int cardinality() {
        int sum = 0;
        for (long l : this.data) {
            sum += Long.bitCount(l);
        }
        return sum;
    }

    public boolean get(int i) {
        return (this.data[i / 64] & 1L << i % 64) != 0L;
    }

    public void set(int i) {
        int n = i / 64;
        this.data[n] = this.data[n] | 1L << i % 64;
    }

    public void unset(int i) {
        int n = i / 64;
        this.data[n] = this.data[n] & (1L << i % 64 ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void set(int i, boolean b) {
        if (b) {
            this.set(i);
        } else {
            this.unset(i);
        }
    }

    public int nextSetBit(int i) {
        int x = i / 64;
        if (x >= this.data.length) {
            return -1;
        }
        long w = this.data[x];
        if ((w >>>= i % 64) != 0L) {
            return i + Long.numberOfTrailingZeros(w);
        }
        ++x;
        while (x < this.data.length) {
            if (this.data[x] != 0L) {
                return x * 64 + Long.numberOfTrailingZeros(this.data[x]);
            }
            ++x;
        }
        return -1;
    }

    public int nextUnsetBit(int i) {
        int x = i / 64;
        if (x >= this.data.length) {
            return -1;
        }
        long w = this.data[x] ^ 0xFFFFFFFFFFFFFFFFL;
        if ((w >>>= i % 64) != 0L) {
            return i + Long.numberOfTrailingZeros(w);
        }
        ++x;
        while (x < this.data.length) {
            if (this.data[x] != -1L) {
                return x * 64 + Long.numberOfTrailingZeros(this.data[x] ^ 0xFFFFFFFFFFFFFFFFL);
            }
            ++x;
        }
        return -1;
    }
}

