/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.BitmapStorage;
import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.IteratingBufferedRunningLengthWord;
import com.googlecode.javaewah.IteratingRLW;
import com.googlecode.javaewah.IteratorAggregation;
import com.googlecode.javaewah.LogicalElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.PriorityQueue;

public final class FastAggregation {
    private FastAggregation() {
    }

    public static EWAHCompressedBitmap bufferedand(int bufSize, EWAHCompressedBitmap ... bitmaps) {
        EWAHCompressedBitmap answer = new EWAHCompressedBitmap();
        FastAggregation.bufferedandWithContainer(answer, bufSize, bitmaps);
        return answer;
    }

    /*
     * WARNING - void declaration
     */
    public static void bufferedandWithContainer(BitmapStorage container, int bufSize, EWAHCompressedBitmap ... bitmaps) {
        void var6_9;
        LinkedList<IteratingBufferedRunningLengthWord> al = new LinkedList<IteratingBufferedRunningLengthWord>();
        EWAHCompressedBitmap[] eWAHCompressedBitmapArray = bitmaps;
        int n = eWAHCompressedBitmapArray.length;
        boolean bl = false;
        while (var6_9 < n) {
            EWAHCompressedBitmap bitmap = eWAHCompressedBitmapArray[var6_9];
            al.add(new IteratingBufferedRunningLengthWord(bitmap));
            ++var6_9;
        }
        long[] hardbitmap = new long[bufSize * bitmaps.length];
        for (IteratingRLW iteratingRLW : al) {
            if (iteratingRLW.size() != 0L) continue;
            al.clear();
            break;
        }
        block2: while (!al.isEmpty()) {
            Arrays.fill(hardbitmap, -1L);
            long effective = Integer.MAX_VALUE;
            for (IteratingRLW iteratingRLW : al) {
                int eff = IteratorAggregation.inplaceand(hardbitmap, iteratingRLW);
                if ((long)eff >= effective) continue;
                effective = eff;
            }
            int k = 0;
            while ((long)k < effective) {
                container.addWord(hardbitmap[k]);
                ++k;
            }
            for (IteratingRLW iteratingRLW : al) {
                if (iteratingRLW.size() != 0L) continue;
                al.clear();
                continue block2;
            }
        }
    }

    public static EWAHCompressedBitmap bufferedor(int bufSize, EWAHCompressedBitmap ... bitmaps) {
        EWAHCompressedBitmap answer = new EWAHCompressedBitmap();
        FastAggregation.bufferedorWithContainer(answer, bufSize, bitmaps);
        return answer;
    }

    public static void bufferedorWithContainer(BitmapStorage container, int bufSize, EWAHCompressedBitmap ... bitmaps) {
        int range = 0;
        EWAHCompressedBitmap[] sbitmaps = (EWAHCompressedBitmap[])bitmaps.clone();
        Arrays.sort(sbitmaps, new Comparator<EWAHCompressedBitmap>(){

            @Override
            public int compare(EWAHCompressedBitmap a, EWAHCompressedBitmap b) {
                return b.sizeInBits - a.sizeInBits;
            }
        });
        ArrayList<IteratingBufferedRunningLengthWord> al = new ArrayList<IteratingBufferedRunningLengthWord>();
        for (EWAHCompressedBitmap bitmap : sbitmaps) {
            if (bitmap.sizeInBits > range) {
                range = bitmap.sizeInBits;
            }
            al.add(new IteratingBufferedRunningLengthWord(bitmap));
        }
        long[] hardbitmap = new long[bufSize];
        int maxr = al.size();
        while (maxr > 0) {
            int k;
            long effective = 0L;
            for (k = 0; k < maxr; ++k) {
                if (((IteratingBufferedRunningLengthWord)al.get(k)).size() > 0L) {
                    int eff = IteratorAggregation.inplaceor(hardbitmap, (IteratingRLW)al.get(k));
                    if ((long)eff <= effective) continue;
                    effective = eff;
                    continue;
                }
                maxr = k;
            }
            k = 0;
            while ((long)k < effective) {
                container.addWord(hardbitmap[k]);
                ++k;
            }
            Arrays.fill(hardbitmap, 0L);
        }
        container.setSizeInBitsWithinLastWord(range);
    }

    public static EWAHCompressedBitmap bufferedxor(int bufSize, EWAHCompressedBitmap ... bitmaps) {
        EWAHCompressedBitmap answer = new EWAHCompressedBitmap();
        FastAggregation.bufferedxorWithContainer(answer, bufSize, bitmaps);
        return answer;
    }

    public static void bufferedxorWithContainer(BitmapStorage container, int bufSize, EWAHCompressedBitmap ... bitmaps) {
        int range = 0;
        EWAHCompressedBitmap[] sbitmaps = (EWAHCompressedBitmap[])bitmaps.clone();
        Arrays.sort(sbitmaps, new Comparator<EWAHCompressedBitmap>(){

            @Override
            public int compare(EWAHCompressedBitmap a, EWAHCompressedBitmap b) {
                return b.sizeInBits - a.sizeInBits;
            }
        });
        ArrayList<IteratingBufferedRunningLengthWord> al = new ArrayList<IteratingBufferedRunningLengthWord>();
        for (EWAHCompressedBitmap bitmap : sbitmaps) {
            if (bitmap.sizeInBits > range) {
                range = bitmap.sizeInBits;
            }
            al.add(new IteratingBufferedRunningLengthWord(bitmap));
        }
        long[] hardbitmap = new long[bufSize];
        int maxr = al.size();
        while (maxr > 0) {
            int k;
            long effective = 0L;
            for (k = 0; k < maxr; ++k) {
                if (((IteratingBufferedRunningLengthWord)al.get(k)).size() > 0L) {
                    int eff = IteratorAggregation.inplacexor(hardbitmap, (IteratingRLW)al.get(k));
                    if ((long)eff <= effective) continue;
                    effective = eff;
                    continue;
                }
                maxr = k;
            }
            k = 0;
            while ((long)k < effective) {
                container.addWord(hardbitmap[k]);
                ++k;
            }
            Arrays.fill(hardbitmap, 0L);
        }
        container.setSizeInBitsWithinLastWord(range);
    }

    public static <T extends LogicalElement> T or(T ... bitmaps) {
        PriorityQueue<LogicalElement> pq = new PriorityQueue<LogicalElement>(bitmaps.length, new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return a.sizeInBytes() - b.sizeInBytes();
            }
        });
        Collections.addAll(pq, bitmaps);
        while (pq.size() > 1) {
            LogicalElement x1 = (LogicalElement)pq.poll();
            LogicalElement x2 = (LogicalElement)pq.poll();
            pq.add(x1.or(x2));
        }
        return (T)((LogicalElement)pq.poll());
    }

    public static void orToContainer(BitmapStorage container, EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length < 2) {
            throw new IllegalArgumentException("We need at least two bitmaps");
        }
        PriorityQueue<EWAHCompressedBitmap> pq = new PriorityQueue<EWAHCompressedBitmap>(bitmaps.length, new Comparator<EWAHCompressedBitmap>(){

            @Override
            public int compare(EWAHCompressedBitmap a, EWAHCompressedBitmap b) {
                return a.sizeInBytes() - b.sizeInBytes();
            }
        });
        Collections.addAll(pq, bitmaps);
        while (pq.size() > 2) {
            EWAHCompressedBitmap x1 = pq.poll();
            EWAHCompressedBitmap x2 = pq.poll();
            pq.add(x1.or(x2));
        }
        pq.poll().orToContainer(pq.poll(), container);
    }

    public static <T extends LogicalElement> T xor(T ... bitmaps) {
        PriorityQueue<LogicalElement> pq = new PriorityQueue<LogicalElement>(bitmaps.length, new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return a.sizeInBytes() - b.sizeInBytes();
            }
        });
        Collections.addAll(pq, bitmaps);
        while (pq.size() > 1) {
            LogicalElement x1 = (LogicalElement)pq.poll();
            LogicalElement x2 = (LogicalElement)pq.poll();
            pq.add(x1.xor(x2));
        }
        return (T)((LogicalElement)pq.poll());
    }

    public static void xorToContainer(BitmapStorage container, EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length < 2) {
            throw new IllegalArgumentException("We need at least two bitmaps");
        }
        PriorityQueue<EWAHCompressedBitmap> pq = new PriorityQueue<EWAHCompressedBitmap>(bitmaps.length, new Comparator<EWAHCompressedBitmap>(){

            @Override
            public int compare(EWAHCompressedBitmap a, EWAHCompressedBitmap b) {
                return a.sizeInBytes() - b.sizeInBytes();
            }
        });
        Collections.addAll(pq, bitmaps);
        while (pq.size() > 2) {
            EWAHCompressedBitmap x1 = pq.poll();
            EWAHCompressedBitmap x2 = pq.poll();
            pq.add(x1.xor(x2));
        }
        pq.poll().xorToContainer(pq.poll(), container);
    }

    /*
     * Unable to fully structure code
     */
    @Deprecated
    public static void legacy_orWithContainer(BitmapStorage container, EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length == 2) {
            bitmaps[0].orToContainer(bitmaps[1], container);
            return;
        }
        sortedBitmaps = (EWAHCompressedBitmap[])bitmaps.clone();
        Arrays.sort(sortedBitmaps, new Comparator<EWAHCompressedBitmap>(){

            @Override
            public int compare(EWAHCompressedBitmap a, EWAHCompressedBitmap b) {
                return a.sizeInBits < b.sizeInBits ? 1 : (a.sizeInBits == b.sizeInBits ? 0 : -1);
            }
        });
        rlws = new IteratingBufferedRunningLengthWord[bitmaps.length];
        maxAvailablePos = 0;
        for (EWAHCompressedBitmap bitmap : sortedBitmaps) {
            iterator = bitmap.getEWAHIterator();
            if (!iterator.hasNext()) continue;
            rlws[maxAvailablePos++] = new IteratingBufferedRunningLengthWord(iterator);
        }
        if (maxAvailablePos == 0) {
            container.setSizeInBitsWithinLastWord(0);
            return;
        }
        maxSize = sortedBitmaps[0].sizeInBits;
        block1: while (true) {
            maxOneRl = 0L;
            minZeroRl = 0x7FFFFFFFFFFFFFFFL;
            minSize = 0x7FFFFFFFFFFFFFFFL;
            numEmptyRl = 0;
            for (i = 0; i < maxAvailablePos; ++i) {
                rlw = rlws[i];
                size = rlw.size();
                if (size == 0L) {
                    maxAvailablePos = i;
                    break;
                }
                minSize = Math.min(minSize, size);
                if (rlw.getRunningBit()) {
                    rl = rlw.getRunningLength();
                    maxOneRl = Math.max(maxOneRl, rl);
                    minZeroRl = 0L;
                    if (rl != 0L || size <= 0L) continue;
                    ++numEmptyRl;
                    continue;
                }
                rl = rlw.getRunningLength();
                minZeroRl = Math.min(minZeroRl, rl);
                if (rl != 0L || size <= 0L) continue;
                ++numEmptyRl;
            }
            if (maxAvailablePos == 0) break;
            if (maxAvailablePos == 1) {
                rlws[0].discharge(container);
                break;
            }
            if (maxOneRl > 0L) {
                container.addStreamOfEmptyWords(true, maxOneRl);
                i = 0;
                while (true) {
                    if (i >= maxAvailablePos) continue block1;
                    rlw = rlws[i];
                    rlw.discardFirstWords(maxOneRl);
                    ++i;
                }
            }
            if (minZeroRl > 0L) {
                container.addStreamOfEmptyWords(false, minZeroRl);
                i = 0;
                while (true) {
                    if (i >= maxAvailablePos) continue block1;
                    rlw = rlws[i];
                    rlw.discardFirstWords(minZeroRl);
                    ++i;
                }
            }
            index = 0;
            if (numEmptyRl == 1) {
                emptyRl = null;
                minNonEmptyRl = 0x7FFFFFFFFFFFFFFFL;
                for (i = 0; i < maxAvailablePos; ++i) {
                    rlw = rlws[i];
                    rl = rlw.getRunningLength();
                    if (rl == 0L) {
                        if (!FastAggregation.$assertionsDisabled && emptyRl != null) {
                            throw new AssertionError();
                        }
                        emptyRl = rlw;
                        continue;
                    }
                    minNonEmptyRl = Math.min(minNonEmptyRl, rl);
                }
                v0 = wordsToWrite = minNonEmptyRl > minSize ? minSize : minNonEmptyRl;
                if (emptyRl != null) {
                    emptyRl.writeLiteralWords((int)wordsToWrite, container);
                }
                index = (int)((long)index + wordsToWrite);
            }
            while ((long)index < minSize) {
                word = 0L;
                for (i = 0; i < maxAvailablePos; ++i) {
                    rlw = rlws[i];
                    if (rlw.getRunningLength() > (long)index) continue;
                    word |= rlw.getLiteralWordAt(index - (int)rlw.getRunningLength());
                }
                container.addWord(word);
                ++index;
            }
            i = 0;
            while (true) {
                if (i < maxAvailablePos) ** break;
                continue block1;
                rlw = rlws[i];
                rlw.discardFirstWords(minSize);
                ++i;
            }
            break;
        }
        container.setSizeInBitsWithinLastWord(maxSize);
    }
}

