/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.exception;

import com.graphql_java_generator.exception.GraphQLRequestExecutionExceptionInterface;
import java.util.List;
import org.springframework.graphql.ResponseError;

public class GraphQLRequestExecutionException
extends Exception
implements GraphQLRequestExecutionExceptionInterface {
    private static final long serialVersionUID = 1L;
    private final List<ResponseError> errors;

    public GraphQLRequestExecutionException(String msg) {
        super(msg);
        this.errors = null;
    }

    public GraphQLRequestExecutionException(String msg, Throwable cause) {
        super(msg, cause);
        this.errors = null;
    }

    public GraphQLRequestExecutionException(List<ResponseError> errors) {
        super(GraphQLRequestExecutionException.buildMessage(errors));
        this.errors = errors;
    }

    @Override
    public List<ResponseError> getErrors() {
        return this.errors;
    }

    private static String buildMessage(List<ResponseError> errors) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (errors == null || errors.size() == 0) {
            sb.append("Unknown error");
        } else {
            sb.append(errors.size());
            sb.append(" error(s) occurred: ");
            for (ResponseError error : errors) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(error.getMessage());
            }
        }
        return sb.toString();
    }
}

