/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client.request;

import com.graphql_java_generator.exception.GraphQLRequestPreparationException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class QueryTokenizer {
    public static final String EMPTY_DELIMITERS = " \n\r\t";
    public static final String MEANINGFUL_DELIMITERS = "{}[]!,:()@\"\\";
    final List<String> tokens;
    int indexOfNextToken = 0;

    public QueryTokenizer(String graphQLRequest) {
        StringTokenizer st = new StringTokenizer(graphQLRequest == null ? "" : graphQLRequest, " \n\r\t{}[]!,:()@\"\\", true);
        this.tokens = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            this.tokens.add(st.nextToken());
        }
    }

    public boolean hasMoreTokens() {
        return this.hasMoreTokens(false);
    }

    public boolean hasMoreTokens(boolean returnEmptyDelimiters) {
        for (int i = this.indexOfNextToken; i < this.tokens.size(); ++i) {
            if (EMPTY_DELIMITERS.contains(this.tokens.get(i))) continue;
            return true;
        }
        return false;
    }

    public String currentToken() {
        if (this.indexOfNextToken == 0) {
            throw new IndexOutOfBoundsException("No token has been read");
        }
        if (this.indexOfNextToken >= this.tokens.size()) {
            throw new RuntimeException("The end of the token list has already been reached");
        }
        return this.tokens.get(this.indexOfNextToken - 1);
    }

    public String nextToken() {
        return this.nextToken(false);
    }

    public String nextToken(boolean returnEmptyDelimiters) {
        String token;
        do {
            if (this.indexOfNextToken >= this.tokens.size()) {
                throw new RuntimeException("No more token where found");
            }
            token = this.tokens.get(this.indexOfNextToken++);
            if (!returnEmptyDelimiters) continue;
            return token;
        } while (EMPTY_DELIMITERS.contains(token));
        return token;
    }

    public boolean checkNextToken(String expected) {
        for (int i = this.indexOfNextToken; i < this.tokens.size(); ++i) {
            if (EMPTY_DELIMITERS.contains(this.tokens.get(i))) continue;
            return this.tokens.get(i).equals(expected);
        }
        return false;
    }

    public boolean checkNextTokenStartsWith(String expectedStart) {
        for (int i = this.indexOfNextToken; i < this.tokens.size(); ++i) {
            if (EMPTY_DELIMITERS.contains(this.tokens.get(i))) continue;
            return this.tokens.get(i).startsWith(expectedStart);
        }
        return false;
    }

    public String readNextRealToken(String expected, String action) throws GraphQLRequestPreparationException {
        if (this.hasMoreTokens()) {
            String token = this.nextToken(false);
            if (expected != null && !expected.equals(token)) {
                throw new GraphQLRequestPreparationException("The token read is '" + token + "', but the expected one is '" + expected + "' while " + action);
            }
            return token;
        }
        throw new GraphQLRequestPreparationException("End of string found while " + action);
    }
}

