/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.FieldDataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.PropertyDataFetcher;
import graphql.schema.SchemaUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GraphQLFieldDefinition {
    private final String name;
    private final String description;
    private GraphQLOutputType type;
    private final DataFetcher dataFetcher;
    private final String deprecationReason;
    private final List<GraphQLArgument> arguments = new ArrayList<GraphQLArgument>();

    public GraphQLFieldDefinition(String name, String description, GraphQLOutputType type, DataFetcher dataFetcher, List<GraphQLArgument> arguments, String deprecationReason) {
        Assert.assertNotNull(name, "name can't be null");
        Assert.assertNotNull(dataFetcher, "dataFetcher can't be null");
        Assert.assertNotNull(type, "type can't be null");
        Assert.assertNotNull(arguments, "arguments can't be null");
        this.name = name;
        this.description = description;
        this.type = type;
        this.dataFetcher = dataFetcher;
        this.arguments.addAll(arguments);
        this.deprecationReason = deprecationReason;
    }

    void replaceTypeReferences(Map<String, GraphQLType> typeMap) {
        this.type = (GraphQLOutputType)new SchemaUtil().resolveTypeReference(this.type, typeMap);
    }

    public String getName() {
        return this.name;
    }

    public GraphQLOutputType getType() {
        return this.type;
    }

    public DataFetcher getDataFetcher() {
        return this.dataFetcher;
    }

    public GraphQLArgument getArgument(String name) {
        for (GraphQLArgument argument : this.arguments) {
            if (!argument.getName().equals(name)) continue;
            return argument;
        }
        return null;
    }

    public List<GraphQLArgument> getArguments() {
        return new ArrayList<GraphQLArgument>(this.arguments);
    }

    public String getDescription() {
        return this.description;
    }

    public String getDeprecationReason() {
        return this.deprecationReason;
    }

    public boolean isDeprecated() {
        return this.deprecationReason != null;
    }

    public static Builder newFieldDefinition() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private String description;
        private GraphQLOutputType type;
        private DataFetcher dataFetcher;
        private List<GraphQLArgument> arguments = new ArrayList<GraphQLArgument>();
        private String deprecationReason;
        private boolean isField;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder type(GraphQLOutputType type) {
            this.type = type;
            return this;
        }

        public Builder dataFetcher(DataFetcher dataFetcher) {
            this.dataFetcher = dataFetcher;
            return this;
        }

        public Builder staticValue(final Object value) {
            this.dataFetcher = new DataFetcher(){

                @Override
                public Object get(DataFetchingEnvironment environment) {
                    return value;
                }
            };
            return this;
        }

        public Builder fetchField() {
            this.isField = true;
            return this;
        }

        public Builder argument(GraphQLArgument argument) {
            this.arguments.add(argument);
            return this;
        }

        public Builder argument(List<GraphQLArgument> arguments) {
            this.arguments.addAll(arguments);
            return this;
        }

        public Builder deprecate(String deprecationReason) {
            this.deprecationReason = deprecationReason;
            return this;
        }

        public GraphQLFieldDefinition build() {
            if (this.dataFetcher == null) {
                this.dataFetcher = this.isField ? new FieldDataFetcher(this.name) : new PropertyDataFetcher(this.name);
            }
            return new GraphQLFieldDefinition(this.name, this.description, this.type, this.dataFetcher, this.arguments, this.deprecationReason);
        }
    }
}

