/*
 * Decompiled with CFR 0.152.
 */
package graphql;

import graphql.language.BooleanValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.GraphQLScalarType;

public class Scalars {
    public static GraphQLScalarType GraphQLInt = new GraphQLScalarType("Int", "Built-in Int", new Coercing(){

        @Override
        public Object serialize(Object input) {
            if (input instanceof String) {
                return Integer.parseInt((String)input);
            }
            if (input instanceof Integer) {
                return input;
            }
            return null;
        }

        @Override
        public Object parseValue(Object input) {
            return this.serialize(input);
        }

        @Override
        public Object parseLiteral(Object input) {
            if (!(input instanceof IntValue)) {
                return null;
            }
            return ((IntValue)input).getValue();
        }
    });
    public static GraphQLScalarType GraphQLLong = new GraphQLScalarType("Long", "Long type", new Coercing(){

        @Override
        public Object serialize(Object input) {
            if (input instanceof String) {
                return Long.parseLong((String)input);
            }
            if (input instanceof Long) {
                return input;
            }
            if (input instanceof Integer) {
                return ((Integer)input).longValue();
            }
            return null;
        }

        @Override
        public Object parseValue(Object input) {
            return this.serialize(input);
        }

        @Override
        public Object parseLiteral(Object input) {
            if (input instanceof StringValue) {
                return Long.parseLong(((StringValue)input).getValue());
            }
            if (input instanceof IntValue) {
                return ((IntValue)input).getValue();
            }
            return null;
        }
    });
    public static GraphQLScalarType GraphQLFloat = new GraphQLScalarType("Float", "Built-in Float", new Coercing(){

        @Override
        public Double serialize(Object input) {
            if (input instanceof String) {
                return Double.parseDouble((String)input);
            }
            if (input instanceof Double) {
                return (Double)input;
            }
            if (input instanceof Float) {
                return ((Float)input).floatValue();
            }
            if (input instanceof Integer) {
                return (double)((Integer)input);
            }
            return null;
        }

        @Override
        public Object parseValue(Object input) {
            return this.serialize(input);
        }

        @Override
        public Object parseLiteral(Object input) {
            return ((FloatValue)input).getValue().doubleValue();
        }
    });
    public static GraphQLScalarType GraphQLString = new GraphQLScalarType("String", "Built-in String", new Coercing(){

        @Override
        public Object serialize(Object input) {
            return input == null ? null : input.toString();
        }

        @Override
        public Object parseValue(Object input) {
            return this.serialize(input);
        }

        @Override
        public Object parseLiteral(Object input) {
            if (!(input instanceof StringValue)) {
                return null;
            }
            return ((StringValue)input).getValue();
        }
    });
    public static GraphQLScalarType GraphQLBoolean = new GraphQLScalarType("Boolean", "Built-in Boolean", new Coercing(){

        @Override
        public Object serialize(Object input) {
            if (input instanceof Boolean) {
                return input;
            }
            if (input instanceof Integer) {
                return (Integer)input > 0;
            }
            if (input instanceof String) {
                return Boolean.parseBoolean((String)input);
            }
            return null;
        }

        @Override
        public Object parseValue(Object input) {
            return this.serialize(input);
        }

        @Override
        public Object parseLiteral(Object input) {
            if (!(input instanceof BooleanValue)) {
                return null;
            }
            return ((BooleanValue)input).isValue();
        }
    });
    public static GraphQLScalarType GraphQLID = new GraphQLScalarType("ID", "Built-in ID", new Coercing(){

        @Override
        public Object serialize(Object input) {
            if (input instanceof String) {
                return input;
            }
            return null;
        }

        @Override
        public Object parseValue(Object input) {
            return this.serialize(input);
        }

        @Override
        public Object parseLiteral(Object input) {
            if (!(input instanceof StringValue)) {
                return null;
            }
            return ((StringValue)input).getValue();
        }
    });
}

