/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.language.TypeName;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationError;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;

public class KnownTypeNames
extends AbstractRule {
    public KnownTypeNames(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkTypeName(TypeName typeName) {
        if (this.getValidationContext().getSchema().getType(typeName.getName()) == null) {
            String message = String.format("Unknown type %s", typeName.getName());
            this.addError(new ValidationError(ValidationErrorType.UnknownType, typeName.getSourceLocation(), message));
        }
    }
}

