/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.activerecord;

import com.jfinal.kit.TypeKit;
import com.litongjava.cache.IDbCache;
import com.litongjava.db.SqlPara;
import com.litongjava.db.activerecord.ActiveRecordException;
import com.litongjava.db.activerecord.Config;
import com.litongjava.db.activerecord.DaoContainerFactory;
import com.litongjava.db.activerecord.DaoTemplate;
import com.litongjava.db.activerecord.Db;
import com.litongjava.db.activerecord.DbKit;
import com.litongjava.db.activerecord.PageSqlKit;
import com.litongjava.db.activerecord.Record;
import com.litongjava.db.activerecord.Table;
import com.litongjava.db.activerecord.TableMapping;
import com.litongjava.db.activerecord.stat.ISqlStatementStat;
import com.litongjava.model.db.IRow;
import com.litongjava.model.page.Page;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public abstract class Model<M extends Model>
implements IRow<M>,
Serializable {
    private static final long serialVersionUID = -990334519496260591L;
    public static final int FILTER_BY_SAVE = 0;
    public static final int FILTER_BY_UPDATE = 1;
    String configName;
    Set<String> modifyFlag;
    private Map<String, Object> attrs = this.createAttrsMap();

    protected abstract String _getPrimaryKey();

    protected abstract String _getTableName();

    private Map<String, Object> createAttrsMap() {
        Config config = this._getWriteConfig();
        if (config == null) {
            return DbKit.brokenConfig.containerFactory.getAttrsMap();
        }
        return config.containerFactory.getAttrsMap();
    }

    public M dao() {
        this.attrs = DaoContainerFactory.daoMap;
        this.modifyFlag = DaoContainerFactory.daoSet;
        return (M)this;
    }

    protected void filter(int filterBy) {
    }

    public Map<String, Object> _getAttrs() {
        return this.attrs;
    }

    public Set<Map.Entry<String, Object>> _getAttrsEntrySet() {
        return this.attrs.entrySet();
    }

    public String[] _getAttrNames() {
        Set<String> attrNameSet = this.attrs.keySet();
        return attrNameSet.toArray(new String[attrNameSet.size()]);
    }

    public Object[] _getAttrValues() {
        Collection<Object> attrValueCollection = this.attrs.values();
        return attrValueCollection.toArray(new Object[attrValueCollection.size()]);
    }

    public M _setAttrs(M model) {
        return this._setAttrs(((Model)model)._getAttrs());
    }

    public M _setAttrs(Map<String, Object> attrs) {
        if (attrs != null) {
            for (Map.Entry<String, Object> e : attrs.entrySet()) {
                this.set(e.getKey(), e.getValue());
            }
        }
        return (M)this;
    }

    protected Set<String> _getModifyFlag() {
        if (this.modifyFlag == null) {
            Config config = this._getWriteConfig();
            this.modifyFlag = config == null ? DbKit.brokenConfig.containerFactory.getModifyFlagSet() : config.containerFactory.getModifyFlagSet();
        }
        return this.modifyFlag;
    }

    void clearModifyFlag() {
        if (this.modifyFlag != null) {
            this.modifyFlag.clear();
        }
    }

    protected Config _getWriteConfig() {
        if (this.configName != null) {
            return DbKit.getConfig(this.configName);
        }
        Config config = DbKit.getConfig(this._getUsefulClass());
        if (config == null) {
            return DbKit.getConfig();
        }
        return config;
    }

    protected Config _getReadConfig() {
        if (this.configName != null) {
            return DbKit.getConfig(this.configName);
        }
        Config config = DbKit.getConfig(this._getUsefulClass());
        if (config == null) {
            return DbKit.getReadConfig();
        }
        return config;
    }

    protected Table _getTable() {
        Table table = TableMapping.me().getTable(this._getUsefulClass());
        if (table == null) {
            return new Table(this._getTableName(), this._getPrimaryKey());
        }
        return table;
    }

    protected Class<? extends Model> _getUsefulClass() {
        Class<?> c = this.getClass();
        String n = c.getName();
        return n.indexOf("_$$_") > -1 || n.indexOf("$$Enhancer") > -1 ? c.getSuperclass() : c;
    }

    public M use(String configName) {
        if (this.attrs == DaoContainerFactory.daoMap) {
            throw new RuntimeException("dao \u53ea\u5141\u8bb8\u8c03\u7528\u67e5\u8be2\u65b9\u6cd5");
        }
        this.configName = configName;
        return (M)this;
    }

    public M set(String attr, Object value) {
        Table table = this._getTable();
        if (table != null && !table.hasColumnLabel(attr)) {
            throw new ActiveRecordException("The attribute name does not exist: \"" + attr + "\"");
        }
        this.attrs.put(attr, value);
        this._getModifyFlag().add(attr);
        return (M)this;
    }

    public M put(String key, Object value) {
        this.attrs.put(key, value);
        return (M)this;
    }

    public M setOrPut(String attrOrNot, Object value) {
        Table table = this._getTable();
        if (table != null && table.hasColumnLabel(attrOrNot)) {
            this._getModifyFlag().add(attrOrNot);
        }
        this.attrs.put(attrOrNot, value);
        return (M)this;
    }

    public M _setOrPut(Map<String, Object> map) {
        if (map != null) {
            for (Map.Entry<String, Object> e : map.entrySet()) {
                this.setOrPut(e.getKey(), e.getValue());
            }
        }
        return (M)this;
    }

    public M _setOrPut(Model model) {
        return this._setOrPut(model._getAttrs());
    }

    public M put(Map<String, Object> map) {
        this.attrs.putAll(map);
        return (M)this;
    }

    public M put(Model model) {
        this.attrs.putAll(model._getAttrs());
        return (M)this;
    }

    public M put(Record record) {
        this.attrs.putAll(record.getColumns());
        return (M)this;
    }

    public Record toRecord() {
        return new Record().setColumns(this._getAttrs());
    }

    public M fromRecord(Record record) {
        this._setAttrs(record.getColumns());
        return (M)this;
    }

    public <T> T get(String attr) {
        return (T)this.attrs.get(attr);
    }

    public <T> T get(String attr, Object defaultValue) {
        Object result = this.attrs.get(attr);
        return (T)(result != null ? result : defaultValue);
    }

    public String getStr(String attr) {
        Object s = this.attrs.get(attr);
        return s != null ? s.toString() : null;
    }

    public Integer getInt(String attr) {
        return TypeKit.toInt((Object)this.attrs.get(attr));
    }

    public Long getLong(String attr) {
        return TypeKit.toLong((Object)this.attrs.get(attr));
    }

    public BigInteger getBigInteger(String attr) {
        Object n = this.attrs.get(attr);
        if (n instanceof BigInteger) {
            return (BigInteger)n;
        }
        if (n instanceof BigDecimal) {
            return ((BigDecimal)n).toBigInteger();
        }
        if (n instanceof Number) {
            return BigInteger.valueOf(((Number)n).longValue());
        }
        if (n instanceof String) {
            return new BigInteger((String)n);
        }
        return (BigInteger)n;
    }

    public Date getDate(String attr) {
        return TypeKit.toDate((Object)this.attrs.get(attr));
    }

    public LocalDateTime getLocalDateTime(String attr) {
        return TypeKit.toLocalDateTime((Object)this.attrs.get(attr));
    }

    public Time getTime(String attr) {
        return (Time)this.attrs.get(attr);
    }

    public Timestamp getTimestamp(String attr) {
        return (Timestamp)this.attrs.get(attr);
    }

    public Double getDouble(String attr) {
        return TypeKit.toDouble((Object)this.attrs.get(attr));
    }

    public Float getFloat(String attr) {
        return TypeKit.toFloat((Object)this.attrs.get(attr));
    }

    public Short getShort(String attr) {
        return TypeKit.toShort((Object)this.attrs.get(attr));
    }

    public Byte getByte(String attr) {
        return TypeKit.toByte((Object)this.attrs.get(attr));
    }

    public Boolean getBoolean(String attr) {
        return TypeKit.toBoolean((Object)this.attrs.get(attr));
    }

    public BigDecimal getBigDecimal(String attr) {
        return TypeKit.toBigDecimal((Object)this.attrs.get(attr));
    }

    public byte[] getBytes(String attr) {
        return (byte[])this.attrs.get(attr);
    }

    public Number getNumber(String attr) {
        return TypeKit.toNumber((Object)this.attrs.get(attr));
    }

    public Page<M> paginate(int pageNumber, int pageSize, String select, String sqlExceptSelect, Object ... paras) {
        return this.doPaginate(pageNumber, pageSize, null, select, sqlExceptSelect, paras);
    }

    public Page<M> paginate(int pageNumber, int pageSize, String select, String sqlExceptSelect) {
        return this.doPaginate(pageNumber, pageSize, null, select, sqlExceptSelect, DbKit.NULL_PARA_ARRAY);
    }

    public Page<M> paginate(int pageNumber, int pageSize, boolean isGroupBySql, String select, String sqlExceptSelect, Object ... paras) {
        return this.doPaginate(pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect, paras);
    }

    protected Page<M> doPaginate(int pageNumber, int pageSize, Boolean isGroupBySql, String select, String sqlExceptSelect, Object ... paras) {
        Config config = this._getReadConfig();
        Connection conn = null;
        try {
            conn = config.getConnection();
            String totalRowSql = config.dialect.forPaginateTotalRow(select, sqlExceptSelect, this);
            StringBuilder findSql = new StringBuilder();
            findSql.append(select).append(' ').append(sqlExceptSelect);
            Page<M> page = this.doPaginateByFullSql(config, conn, pageNumber, pageSize, isGroupBySql, totalRowSql, findSql, paras);
            return page;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            config.close(conn);
        }
    }

    protected Page<M> doPaginateByFullSql(Config config, Connection conn, int pageNumber, int pageSize, Boolean isGroupBySql, String totalRowSql, StringBuilder findSql, Object ... paras) throws Exception {
        long totalRow;
        if (pageNumber < 1 || pageSize < 1) {
            throw new ActiveRecordException("pageNumber and pageSize must more than 0");
        }
        if (config.dialect.isTakeOverModelPaginate()) {
            return config.dialect.takeOverModelPaginate(conn, this._getUsefulClass(), pageNumber, pageSize, isGroupBySql, totalRowSql, findSql, paras);
        }
        List result = Db.query(config, conn, totalRowSql, paras);
        int size = result.size();
        if (isGroupBySql == null) {
            isGroupBySql = size > 1;
        }
        if (isGroupBySql.booleanValue()) {
            totalRow = size;
        } else {
            long l = totalRow = size > 0 ? ((Number)result.get(0)).longValue() : 0L;
        }
        if (totalRow == 0L) {
            return new Page(new ArrayList(0), pageNumber, pageSize, 0, 0);
        }
        int totalPage = (int)(totalRow / (long)pageSize);
        if (totalRow % (long)pageSize != 0L) {
            ++totalPage;
        }
        if (pageNumber > totalPage) {
            return new Page(new ArrayList(0), pageNumber, pageSize, totalPage, (int)totalRow);
        }
        String sql = config.dialect.forPaginate(pageNumber, pageSize, findSql);
        List<M> list = this.find(config, conn, sql, paras);
        return new Page(list, pageNumber, pageSize, totalPage, (int)totalRow);
    }

    protected Page<M> doPaginateByFullSql(int pageNumber, int pageSize, Boolean isGroupBySql, String totalRowSql, String findSql, Object ... paras) {
        Config config = this._getReadConfig();
        Connection conn = null;
        try {
            conn = config.getConnection();
            StringBuilder findSqlBuf = new StringBuilder().append(findSql);
            Page<M> page = this.doPaginateByFullSql(config, conn, pageNumber, pageSize, isGroupBySql, totalRowSql, findSqlBuf, paras);
            return page;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            config.close(conn);
        }
    }

    public Page<M> paginateByFullSql(int pageNumber, int pageSize, String totalRowSql, String findSql, Object ... paras) {
        return this.doPaginateByFullSql(pageNumber, pageSize, null, totalRowSql, findSql, paras);
    }

    public Page<M> paginateByFullSql(int pageNumber, int pageSize, boolean isGroupBySql, String totalRowSql, String findSql, Object ... paras) {
        return this.doPaginateByFullSql(pageNumber, pageSize, isGroupBySql, totalRowSql, findSql, paras);
    }

    public boolean save() {
        this.filter(0);
        Config config = this._getWriteConfig();
        Table table = this._getTable();
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> paras = new ArrayList<Object>();
        config.dialect.forModelSave(table, this.attrs, sql, paras);
        Connection conn = null;
        PreparedStatement pst = null;
        int result = 0;
        conn = config.getConnection();
        if (config.dialect.isOracle()) {
            try {
                pst = conn.prepareStatement(sql.toString(), table.getPrimaryKey());
            }
            catch (SQLException e) {
                throw new RuntimeException(e.getMessage() + " " + sql.toString(), e);
            }
        }
        try {
            pst = conn.prepareStatement(sql.toString(), 1);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage() + " " + sql.toString(), e);
        }
        try {
            config.dialect.fillStatement(pst, paras);
        }
        catch (SQLException e) {
            throw new RuntimeException(((Object)paras).toString(), e);
        }
        result = 0;
        try {
            result = pst.executeUpdate();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage() + " " + sql.toString(), e);
        }
        try {
            config.dialect.getModelGeneratedKey(this, pst, table);
        }
        catch (SQLException e) {
            throw new RuntimeException(((Object)paras).toString(), e);
        }
        finally {
            config.close(pst, conn);
        }
        this.clearModifyFlag();
        return result >= 1;
    }

    public boolean deleteById() {
        Table table = this._getTable();
        String[] pKeys = table.getPrimaryKey();
        if (pKeys.length == 1) {
            Object id = this.attrs.get(pKeys[0]);
            if (id == null) {
                throw new ActiveRecordException("Primary key " + pKeys[0] + " can not be null");
            }
            return this.deleteById(table, id);
        }
        Object[] ids = new Object[pKeys.length];
        for (int i = 0; i < pKeys.length; ++i) {
            ids[i] = this.attrs.get(pKeys[i]);
            if (ids[i] != null) continue;
            throw new ActiveRecordException("Primary key " + pKeys[i] + " can not be null");
        }
        return this.deleteById(table, ids);
    }

    public boolean delete() {
        Table table = this._getTable();
        Record record = this.toRecord();
        return Db.delete(table.getName(), record);
    }

    public boolean deleteById(Object idValue) {
        if (idValue == null) {
            throw new IllegalArgumentException("idValue can not be null");
        }
        return this.deleteById(this._getTable(), idValue);
    }

    public boolean deleteByIds(Object ... idValues) {
        Table table = this._getTable();
        if (idValues == null || idValues.length != table.getPrimaryKey().length) {
            throw new IllegalArgumentException("Primary key nubmer must equals id value number and can not be null");
        }
        return this.deleteById(table, idValues);
    }

    protected boolean deleteById(Table table, Object ... idValues) {
        Config config = this._getWriteConfig();
        Connection conn = null;
        try {
            conn = config.getConnection();
            String sql = config.dialect.forModelDeleteById(table);
            boolean bl = Db.update(config, conn, sql, idValues) >= 1;
            return bl;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            config.close(conn);
        }
    }

    public boolean update() {
        String[] pKeys;
        this.filter(1);
        if (this.modifyFlag == null || this.modifyFlag.isEmpty()) {
            return false;
        }
        Table table = this._getTable();
        for (String pKey : pKeys = table.getPrimaryKey()) {
            Object id = this.attrs.get(pKey);
            if (id != null) continue;
            throw new ActiveRecordException("You can't update model without Primary Key, " + pKey + " can not be null.");
        }
        Config config = this._getWriteConfig();
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> paras = new ArrayList<Object>();
        config.dialect.forModelUpdate(table, this.attrs, this._getModifyFlag(), sql, paras);
        if (paras.size() <= 1) {
            return false;
        }
        Connection conn = null;
        try {
            conn = config.getConnection();
            int result = Db.update(config, conn, sql.toString(), paras.toArray());
            if (result >= 1) {
                this.clearModifyFlag();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            config.close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<M> find(String tableName, String columns, Record record) {
        Connection conn = null;
        Config config = this._getReadConfig();
        try {
            conn = config.getConnection();
            List<M> list = this.find(config, conn, tableName, columns, record);
            return list;
        }
        finally {
            config.close(conn);
        }
    }

    protected List<M> find(Config config, Connection conn, String sql, Object ... paras) {
        PreparedStatement pst = null;
        try {
            pst = conn.prepareStatement(sql);
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e);
        }
        try {
            config.dialect.fillStatement(pst, paras);
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e);
        }
        ResultSet rs = null;
        try {
            rs = pst.executeQuery();
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e);
        }
        List result = null;
        try {
            result = config.dialect.buildModelList(rs, this._getUsefulClass());
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e);
        }
        catch (ReflectiveOperationException e) {
            throw new ActiveRecordException(e);
        }
        finally {
            try {
                DbKit.close(rs);
            }
            catch (SQLException e) {
                throw new ActiveRecordException(e);
            }
            try {
                DbKit.close(pst);
            }
            catch (SQLException e) {
                throw new ActiveRecordException(e);
            }
        }
        return result;
    }

    public List<M> find() {
        Config config = this._getReadConfig();
        Table table = this._getTable();
        return this.find(config, table.getName(), this.toRecord());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<M> find(Config config, String tableName, Record record) {
        Connection conn = null;
        try {
            conn = config.getConnection();
            List<M> list = this.find(config, conn, tableName, "*", record);
            return list;
        }
        finally {
            config.close(conn);
        }
    }

    protected List<M> find(Config config, Connection conn, String tableName, String columns, Record record) {
        ResultSet rs;
        PreparedStatement pst;
        ArrayList<Object> paras = new ArrayList<Object>();
        StringBuffer sqlBuffer = config.dialect.forDbFind(tableName, columns, record, paras);
        try {
            pst = conn.prepareStatement(sqlBuffer.toString());
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e);
        }
        try {
            config.dialect.fillStatement(pst, paras);
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e);
        }
        List result = null;
        long start = System.currentTimeMillis();
        try {
            rs = pst.executeQuery();
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e.getMessage() + " " + sqlBuffer.toString(), e);
        }
        try {
            result = config.dialect.buildModelList(rs, this._getUsefulClass());
        }
        catch (SQLException e) {
            throw new ActiveRecordException(e);
        }
        catch (ReflectiveOperationException e) {
            throw new ActiveRecordException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    throw new ActiveRecordException(e);
                }
            }
            if (pst != null) {
                try {
                    pst.close();
                }
                catch (SQLException e) {
                    throw new ActiveRecordException(e);
                }
            }
        }
        ISqlStatementStat stat = config.getSqlStatementStat();
        if (stat != null) {
            long end = System.currentTimeMillis();
            long elapsed = end - start;
            stat.save(config.name, "find", sqlBuffer.toString(), paras, result.size(), start, elapsed, config.writeSync);
        }
        return result;
    }

    protected List<M> find(Config config, String sql, Object ... paras) {
        Connection conn = null;
        try {
            conn = config.getConnection();
            List<M> list = this.find(config, conn, sql, paras);
            return list;
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            config.close(conn);
        }
    }

    public List<M> find(String sql, Object ... paras) {
        return this.find(this._getReadConfig(), sql, paras);
    }

    public List<M> find(String sql) {
        return this.find(sql, DbKit.NULL_PARA_ARRAY);
    }

    public List<M> findAll() {
        Config config = this._getReadConfig();
        String sql = config.dialect.forFindAll(this._getTable().getName());
        return this.find(config, sql, DbKit.NULL_PARA_ARRAY);
    }

    public M findFirst(String sql, Object ... paras) {
        List<M> result = this.find(sql, paras);
        return (M)(result.size() > 0 ? (Model)result.get(0) : null);
    }

    public M findFirst(String sql) {
        return this.findFirst(sql, DbKit.NULL_PARA_ARRAY);
    }

    public M findFirst() {
        Table table = this._getTable();
        return this.findFirst(table.getName(), this.toRecord());
    }

    public M findColumnsFirst(String columns) {
        Table table = this._getTable();
        return this.findFirst(table.getName(), columns, this.toRecord());
    }

    public M findFirst(String tableName, String columns, Record record) {
        List<M> result = this.find(tableName, columns, record);
        return (M)(result.size() > 0 ? (Model)result.get(0) : null);
    }

    public M findFirst(String tableName, Record record) {
        List<M> result = this.find(tableName, "*", record);
        return (M)(result.size() > 0 ? (Model)result.get(0) : null);
    }

    public M findById(Object idValue) {
        return this.findByIdLoadColumns(new Object[]{idValue}, "*");
    }

    public M findByIds(Object ... idValues) {
        return this.findByIdLoadColumns(idValues, "*");
    }

    public M findByIdLoadColumns(Object idValue, String columns) {
        return this.findByIdLoadColumns(new Object[]{idValue}, columns);
    }

    public M findByIdLoadColumns(Object[] idValues, String columns) {
        String sql;
        Table table = this._getTable();
        if (table.getPrimaryKey().length != idValues.length) {
            throw new IllegalArgumentException("id values error, need " + table.getPrimaryKey().length + " id value");
        }
        Config config = this._getReadConfig();
        List<M> result = this.find(config, sql = config.dialect.forModelFindById(table, columns), idValues);
        return (M)(result.size() > 0 ? (Model)result.get(0) : null);
    }

    public M remove(String attr) {
        this.attrs.remove(attr);
        this._getModifyFlag().remove(attr);
        return (M)this;
    }

    public M remove(String ... attrs) {
        if (attrs != null) {
            for (String a : attrs) {
                this.attrs.remove(a);
                this._getModifyFlag().remove(a);
            }
        }
        return (M)this;
    }

    public M removeNullValueAttrs() {
        Iterator<Map.Entry<String, Object>> it = this.attrs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> e = it.next();
            if (e.getValue() != null) continue;
            it.remove();
            this._getModifyFlag().remove(e.getKey());
        }
        return (M)this;
    }

    public M keep(String ... attrs) {
        if (attrs != null && attrs.length > 0) {
            Config config = this._getWriteConfig();
            if (config == null) {
                config = DbKit.brokenConfig;
            }
            Map newAttrs = config.containerFactory.getAttrsMap();
            Set newModifyFlag = config.containerFactory.getModifyFlagSet();
            for (String a : attrs) {
                if (this.attrs.containsKey(a)) {
                    newAttrs.put(a, this.attrs.get(a));
                }
                if (!this._getModifyFlag().contains(a)) continue;
                newModifyFlag.add(a);
            }
            this.attrs = newAttrs;
            this.modifyFlag = newModifyFlag;
        } else {
            this.attrs.clear();
            this.clearModifyFlag();
        }
        return (M)this;
    }

    public M keep(String attr) {
        if (this.attrs.containsKey(attr)) {
            Object keepIt = this.attrs.get(attr);
            boolean keepFlag = this._getModifyFlag().contains(attr);
            this.attrs.clear();
            this.clearModifyFlag();
            this.attrs.put(attr, keepIt);
            if (keepFlag) {
                this._getModifyFlag().add(attr);
            }
        } else {
            this.attrs.clear();
            this.clearModifyFlag();
        }
        return (M)this;
    }

    public M clear() {
        this.attrs.clear();
        this.clearModifyFlag();
        return (M)this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean first = true;
        for (Map.Entry<String, Object> e : this.attrs.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            Object value = e.getValue();
            if (value != null) {
                value = value.toString();
            }
            sb.append(e.getKey()).append(':').append(value);
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Model)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        Model mo = (Model)o;
        if (this.getClass() != mo.getClass()) {
            return false;
        }
        return this.attrs.equals(mo.attrs);
    }

    public int hashCode() {
        return this.attrs.hashCode();
    }

    public List<M> findByCache(String cacheName, Object key, String sql, Object ... paras) {
        Config config = this._getReadConfig();
        IDbCache cache = config.getCache();
        List<M> result = (List<M>)cache.get(cacheName, key);
        if (result == null) {
            result = this.find(config, sql, paras);
            cache.put(cacheName, key, result);
        }
        return result;
    }

    public List<M> findByCache(String cacheName, Object key, String sql) {
        return this.findByCache(cacheName, key, sql, DbKit.NULL_PARA_ARRAY);
    }

    public M findFirstByCache(String cacheName, Object key, String sql, Object ... paras) {
        IDbCache cache = this._getReadConfig().getCache();
        Model<M> result = (Model)cache.get(cacheName, key);
        if (result == null) {
            result = this.findFirst(sql, paras);
            cache.put(cacheName, key, (Object)result);
        }
        return (M)result;
    }

    public M findFirstByCache(String cacheName, Object key, String sql) {
        return this.findFirstByCache(cacheName, key, sql, DbKit.NULL_PARA_ARRAY);
    }

    public Page<M> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, String select, String sqlExceptSelect, Object ... paras) {
        return this.doPaginateByCache(cacheName, key, pageNumber, pageSize, null, select, sqlExceptSelect, paras);
    }

    public Page<M> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, String select, String sqlExceptSelect) {
        return this.doPaginateByCache(cacheName, key, pageNumber, pageSize, null, select, sqlExceptSelect, DbKit.NULL_PARA_ARRAY);
    }

    public Page<M> paginateByCache(String cacheName, Object key, int pageNumber, int pageSize, boolean isGroupBySql, String select, String sqlExceptSelect, Object ... paras) {
        return this.doPaginateByCache(cacheName, key, pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect, paras);
    }

    protected Page<M> doPaginateByCache(String cacheName, Object key, int pageNumber, int pageSize, Boolean isGroupBySql, String select, String sqlExceptSelect, Object ... paras) {
        IDbCache cache = this._getReadConfig().getCache();
        Page<M> result = (Page<M>)cache.get(cacheName, key);
        if (result == null) {
            result = this.doPaginate(pageNumber, pageSize, isGroupBySql, select, sqlExceptSelect, paras);
            cache.put(cacheName, key, result);
        }
        return result;
    }

    public String getSql(String key) {
        return this._getWriteConfig().getSqlKit().getSql(key);
    }

    public SqlPara getSqlPara(String key, Map data) {
        return this._getWriteConfig().getSqlKit().getSqlPara(key, data);
    }

    public SqlPara getSqlPara(String key, Object ... paras) {
        return this._getWriteConfig().getSqlKit().getSqlPara(key, paras);
    }

    public SqlPara getSqlPara(String key, Model model) {
        return this.getSqlPara(key, model.attrs);
    }

    public SqlPara getSqlParaByString(String content, Map data) {
        return this._getWriteConfig().getSqlKit().getSqlParaByString(content, data);
    }

    public SqlPara getSqlParaByString(String content, Object ... paras) {
        return this._getWriteConfig().getSqlKit().getSqlParaByString(content, paras);
    }

    public SqlPara getSqlParaByString(String content, Model model) {
        return this.getSqlParaByString(content, model.attrs);
    }

    public List<M> find(SqlPara sqlPara) {
        return this.find(sqlPara.getSql(), sqlPara.getPara());
    }

    public M findFirst(SqlPara sqlPara) {
        return this.findFirst(sqlPara.getSql(), sqlPara.getPara());
    }

    public Page<M> paginate(int pageNumber, int pageSize, SqlPara sqlPara) {
        String[] sqls = PageSqlKit.parsePageSql(sqlPara.getSql());
        return this.doPaginate(pageNumber, pageSize, null, sqls[0], sqls[1], sqlPara.getPara());
    }

    public Page<M> paginate(int pageNumber, int pageSize, boolean isGroupBySql, SqlPara sqlPara) {
        String[] sqls = PageSqlKit.parsePageSql(sqlPara.getSql());
        return this.doPaginate(pageNumber, pageSize, isGroupBySql, sqls[0], sqls[1], sqlPara.getPara());
    }

    public void each(Function<M, Boolean> func, String sql, Object ... paras) {
        Config config = this._getWriteConfig();
        Connection conn = null;
        try {
            conn = config.getConnection();
            try (PreparedStatement pst = conn.prepareStatement(sql);){
                config.dialect.fillStatement(pst, paras);
                ResultSet rs = pst.executeQuery();
                config.dialect.eachModel(rs, this._getUsefulClass(), func);
                DbKit.close(rs);
            }
        }
        catch (Exception e) {
            throw new ActiveRecordException(e);
        }
        finally {
            config.close(conn);
        }
    }

    public DaoTemplate<M> template(String key, Map data) {
        return new DaoTemplate(this, key, data);
    }

    public DaoTemplate<M> template(String key, Object ... paras) {
        return new DaoTemplate(this, key, paras);
    }

    public DaoTemplate<M> template(String key, Model model) {
        return this.template(key, model.attrs);
    }

    public DaoTemplate<M> templateByString(String content, Map data) {
        return new DaoTemplate(true, this, content, data);
    }

    public DaoTemplate<M> templateByString(String content, Object ... paras) {
        return new DaoTemplate(true, this, content, paras);
    }

    public DaoTemplate<M> templateByString(String content, Model model) {
        return this.templateByString(content, model.attrs);
    }

    public Map<String, Object> toMap() {
        return this.attrs;
    }

    public int size() {
        return this.attrs.size();
    }
}

