/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.activerecord;

import com.litongjava.db.activerecord.ActiveRecordException;
import com.litongjava.db.activerecord.Config;
import com.litongjava.db.activerecord.DbKit;
import com.litongjava.db.activerecord.NullDataSource;
import com.litongjava.db.activerecord.Table;
import com.litongjava.db.activerecord.TableMapping;
import com.litongjava.model.db.JavaType;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableBuilder {
    private static final Logger log = LoggerFactory.getLogger(TableBuilder.class);
    protected JavaType javaType = new JavaType();

    public JavaType getJavaType() {
        return this.javaType;
    }

    public void setJavaType(JavaType javaType) {
        this.javaType = javaType;
    }

    public void build(List<Table> tableList, Config config) {
        if (config.dataSource instanceof NullDataSource) {
            return;
        }
        Table temp = null;
        Connection conn = null;
        try {
            conn = config.dataSource.getConnection();
            TableMapping tableMapping = TableMapping.me();
            Iterator<Table> iterator = tableList.iterator();
            while (iterator.hasNext()) {
                Table table;
                temp = table = iterator.next();
                try {
                    this.doBuild(table, conn, config);
                }
                catch (Exception e) {
                    log.error("Failed to build:{}", (Object)table);
                    e.printStackTrace();
                }
                tableMapping.putTable(table);
                DbKit.addModelToConfigMapping(table.getModelClass(), config);
            }
        }
        catch (Exception e) {
            if (temp != null) {
                System.err.println("Can not create Table object, maybe the table " + temp.getName() + " is not exists.");
            }
            throw new ActiveRecordException(e);
        }
        finally {
            config.close(conn);
        }
    }

    protected void doBuild(Table table, Connection conn, Config config) throws SQLException {
        table.setColumnTypeMap(config.containerFactory.getAttrsMap());
        if (table.getPrimaryKey() == null) {
            table.setPrimaryKey(config.dialect.getDefaultPrimaryKey());
        }
        String sql = config.dialect.forTableBuilderDoBuild(table.getName());
        Statement stm = conn.createStatement();
        ResultSet rs = stm.executeQuery(sql);
        ResultSetMetaData rsmd = rs.getMetaData();
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            String colName = rsmd.getColumnName(i);
            String colClassName = rsmd.getColumnClassName(i);
            Class clazz = this.javaType.getType(colClassName);
            if (clazz != null) {
                table.setColumnType(colName, clazz);
                continue;
            }
            int type = rsmd.getColumnType(i);
            if (type == -2 || type == -3 || type == 2004) {
                table.setColumnType(colName, byte[].class);
                continue;
            }
            if (type == 2005 || type == 2011) {
                table.setColumnType(colName, String.class);
                continue;
            }
            if (type == 93) {
                table.setColumnType(colName, Timestamp.class);
                continue;
            }
            if (type == 91) {
                table.setColumnType(colName, Date.class);
                continue;
            }
            if (type == 1111) {
                table.setColumnType(colName, Object.class);
                continue;
            }
            table.setColumnType(colName, String.class);
        }
        rs.close();
        stm.close();
    }
}

