/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.db.activerecord;

import com.litongjava.db.activerecord.Model;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class ModelBuilder {
    public static final ModelBuilder me = new ModelBuilder();

    public <T> List<T> build(ResultSet rs, Class<? extends Model> modelClass) throws SQLException, ReflectiveOperationException {
        return this.build(rs, modelClass, null);
    }

    public <T> List<T> build(ResultSet rs, Class<? extends Model> modelClass, Function<T, Boolean> func) throws SQLException, ReflectiveOperationException {
        ArrayList<Model> result = new ArrayList<Model>();
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        String[] labelNames = new String[columnCount + 1];
        int[] types = new int[columnCount + 1];
        this.buildLabelNamesAndTypes(rsmd, labelNames, types);
        while (rs.next()) {
            Model ar = modelClass.newInstance();
            Map<String, Object> attrs = ar._getAttrs();
            for (int i = 1; i <= columnCount; ++i) {
                Object value = types[i] < 2004 ? rs.getObject(i) : (types[i] == 2005 ? this.handleClob(rs.getClob(i)) : (types[i] == 2011 ? this.handleClob(rs.getNClob(i)) : (types[i] == 2004 ? (Object)this.handleBlob(rs.getBlob(i)) : rs.getObject(i))));
                attrs.put(labelNames[i], value);
            }
            if (func == null) {
                result.add(ar);
                continue;
            }
            if (func.apply(ar).booleanValue()) continue;
            break;
        }
        return result;
    }

    public void buildLabelNamesAndTypes(ResultSetMetaData rsmd, String[] labelNames, int[] types) throws SQLException {
        for (int i = 1; i < labelNames.length; ++i) {
            labelNames[i] = rsmd.getColumnLabel(i);
            types[i] = rsmd.getColumnType(i);
        }
    }

    public byte[] handleBlob(Blob blob) throws SQLException {
        if (blob == null) {
            return null;
        }
        InputStream is = null;
        try {
            is = blob.getBinaryStream();
            if (is == null) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] data = new byte[(int)blob.length()];
            if (data.length == 0) {
                byte[] byArray = null;
                return byArray;
            }
            is.read(data);
            byte[] byArray = data;
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public String handleClob(Clob clob) throws SQLException {
        if (clob == null) {
            return null;
        }
        Reader reader = null;
        try {
            reader = clob.getCharacterStream();
            if (reader == null) {
                String string = null;
                return string;
            }
            char[] buffer = new char[(int)clob.length()];
            if (buffer.length == 0) {
                String string = null;
                return string;
            }
            reader.read(buffer);
            String string = new String(buffer);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public Object handleArray(Array array) {
        Object arrayObj = null;
        try {
            arrayObj = array.getArray();
        }
        catch (Exception e) {
            if (e instanceof NullPointerException) {
                return null;
            }
            e.printStackTrace();
        }
        return arrayObj;
    }
}

