/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.audio.mp3;

import com.litongjava.utils.audio.mp3.WaveHeader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class MP3Util {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void pcmToMP3(String pcmFilePath, String mp3FilePath, int simpleRate) {
        int pcmSize = 0;
        byte[] buf = new byte[4096];
        int size = 0;
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            fis = new FileInputStream(pcmFilePath);
            bis = new BufferedInputStream(fis);
            size = bis.read(buf);
            while (size != -1) {
                pcmSize += size;
                size = bis.read(buf);
            }
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            IOUtils.closeQuietly((InputStream)fis);
            IOUtils.closeQuietly(bis);
        }
        catch (IOException e) {
            e.printStackTrace();
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    IOUtils.closeQuietly(bis);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)fis);
            IOUtils.closeQuietly(bis);
        }
        IOUtils.closeQuietly((InputStream)fis);
        IOUtils.closeQuietly((InputStream)bis);
        WaveHeader header = new WaveHeader();
        header.fileLength = pcmSize + 36;
        header.FmtHdrLeth = 16;
        header.BitsPerSample = (short)16;
        header.Channels = 1;
        header.FormatTag = 1;
        header.SamplesPerSec = simpleRate;
        header.BlockAlign = (short)(header.Channels * header.BitsPerSample / 8);
        header.AvgBytesPerSec = header.BlockAlign * header.SamplesPerSec;
        header.DataHdrLeth = pcmSize;
        byte[] h = header.getHeader();
        assert (h.length == 44);
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        try {
            fos = new FileOutputStream(mp3FilePath);
            bos = new BufferedOutputStream(fos);
            fis = new FileInputStream(pcmFilePath);
            bis = new BufferedInputStream(fis);
            bos.write(h, 0, h.length);
            size = fis.read(buf);
            while (size != -1) {
                bos.write(buf, 0, size);
                size = fis.read(buf);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            IOUtils.closeQuietly((OutputStream)fos);
            IOUtils.closeQuietly(bos);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fos);
                    IOUtils.closeQuietly(bos);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)fos);
            IOUtils.closeQuietly(bos);
        }
        IOUtils.closeQuietly((OutputStream)fos);
        IOUtils.closeQuietly((OutputStream)bos);
    }
}

