/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.image;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class ImageUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] reduce(byte[] bytes) {
        MemoryCacheImageInputStream inputStream = new MemoryCacheImageInputStream(new ByteArrayInputStream(bytes));
        BufferedImage srcImage = null;
        String formatName = null;
        try {
            srcImage = ImageIO.read(inputStream);
            formatName = ImageUtils.getImageFormatByBytes(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((Closeable)inputStream);
        }
        AffineTransformOp ato = ImageUtils.getAffineTransformOp(0.5);
        BufferedImage destImage = ato.filter(srcImage, null);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] retval = null;
        try {
            ImageIO.write((RenderedImage)destImage, formatName, (OutputStream)outputStream);
            retval = outputStream.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        return retval;
    }

    public static String getImageFormatByBytes(byte[] content) {
        String string;
        MemoryCacheImageInputStream input = null;
        try {
            input = new MemoryCacheImageInputStream(new ByteArrayInputStream(content));
            string = ImageUtils.getImageFormat(input);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)input);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImageFormat(ImageInputStream input) {
        Iterator<ImageReader> readers = ImageIO.getImageReaders(input);
        String format = "unknown";
        if (readers.hasNext()) {
            ImageReader reader = readers.next();
            try {
                format = reader.getFormatName();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                reader.dispose();
            }
        }
        return format;
    }

    private static AffineTransformOp getAffineTransformOp(double d) {
        AffineTransform scaleInstance = AffineTransform.getScaleInstance(d, d);
        return new AffineTransformOp(scaleInstance, null);
    }
}

