/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.utils.excel;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.litongjava.utils.string.StringUtils;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;

public class ExcelUtils {
    public static <T> void writeExcel(String fileName, String sheetName, List<T> data, Class<T> clazz) {
        ExcelUtils.writeExcel(null, fileName, sheetName, data, clazz);
    }

    public static <T> void writeExcel(Set<String> attrName, String fileName, String sheetName, List<T> data, Class<T> clazz) {
        fileName = StringUtils.isBlank(fileName) ? "\u5b66\u751f\u7ba1\u7406\u7cfb\u7edf" : fileName;
        sheetName = StringUtils.isBlank(sheetName) ? "sheet0" : sheetName;
        try (FileOutputStream fos = new FileOutputStream(fileName);){
            ExcelUtils.write(fos, attrName, sheetName, data, clazz);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static <T> List<T> readExcel(String fileName, Class<T> clazz) {
        return ExcelUtils.readExcel(fileName, clazz, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> List<T> readExcel(String fileName, Class<T> clazz, ReadListener<T> readListener) {
        try (FileInputStream fis = new FileInputStream(fileName);){
            List<T> list = ExcelUtils.read(fis, clazz, readListener);
            return list;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static <T> void export(HttpServletResponse response, String fileName, String sheetName, List<T> data, Class<T> clazz) {
        ExcelUtils.export(response, null, fileName, sheetName, data, clazz);
    }

    public static <T> void export(HttpServletResponse response, Set<String> attrName, String fileName, String sheetName, List<T> data, Class<T> clazz) {
        fileName = StringUtils.isBlank(fileName) ? "export-excel" : fileName;
        sheetName = StringUtils.isBlank(sheetName) ? "sheet0" : sheetName;
        response.setContentType("application/vnd.ms-excel;charset=utf-8");
        response.setCharacterEncoding("utf-8");
        try {
            fileName = new String(fileName.getBytes("utf-8"), "ISO8859-1");
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        response.addHeader("Content-disposition", "attachment;filename=" + fileName + ExcelTypeEnum.XLSX.getValue());
        try (ServletOutputStream os = response.getOutputStream();){
            ExcelUtils.write((OutputStream)os, attrName, sheetName, data, clazz);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static <T> void write(OutputStream os, Set<String> attrName, String sheetName, List<T> data, Class<T> clazz) {
        ExcelWriterBuilder write = EasyExcel.write((OutputStream)os, clazz);
        if (!CollectionUtils.isEmpty(attrName)) {
            write.includeColumnFiledNames(attrName);
        }
        ((ExcelWriterBuilder)write.registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName).doWrite(data);
    }

    public static <T> List<T> read(InputStream in, Class<T> clazz, ReadListener<T> readListener) {
        final ArrayList list = new ArrayList();
        Optional<ReadListener<1>> optional = Optional.ofNullable(readListener);
        EasyExcel.read((InputStream)in, clazz, (ReadListener)((ReadListener)optional.orElse((ReadListener<1>)new AnalysisEventListener<T>(){

            public void invoke(T data, AnalysisContext context) {
                list.add(data);
            }

            public void doAfterAllAnalysed(AnalysisContext context) {
                System.out.println("\u89e3\u6790\u5b8c\u6210");
            }
        }))).sheet().doRead();
        return list;
    }
}

