/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.whipser.cpp.java;

import com.litongjava.whipser.cpp.java.WhisperCppJnaLibrary;
import com.litongjava.whipser.cpp.java.bean.WhisperSegment;
import com.litongjava.whipser.cpp.java.params.WhisperFullParams;
import com.litongjava.whipser.cpp.java.params.WhisperSamplingStrategy;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class WhisperCpp
implements AutoCloseable {
    private WhisperCppJnaLibrary lib = WhisperCppJnaLibrary.instance;
    private Pointer ctx = null;
    private Pointer greedyPointer = null;
    private Pointer beamPointer = null;

    public File modelDir() {
        String modelDirPath = System.getenv("XDG_CACHE_HOME");
        if (modelDirPath == null) {
            modelDirPath = System.getProperty("user.home") + "/.cache";
        }
        return new File(modelDirPath, "whisper");
    }

    public void initContext(String modelPath) throws FileNotFoundException {
        if (this.ctx != null) {
            this.lib.whisper_free(this.ctx);
        }
        if (!modelPath.contains("/") && !modelPath.contains("\\")) {
            if (!modelPath.endsWith(".bin")) {
                modelPath = "ggml-" + modelPath.replace("-", ".") + ".bin";
            }
            modelPath = new File(this.modelDir(), modelPath).getAbsolutePath();
        }
        this.ctx = this.lib.whisper_init_from_file(modelPath);
        if (this.ctx == null) {
            throw new FileNotFoundException(modelPath);
        }
    }

    public WhisperFullParams getFullDefaultParams(WhisperSamplingStrategy strategy) {
        Pointer pointer;
        if (strategy == WhisperSamplingStrategy.WHISPER_SAMPLING_GREEDY) {
            if (this.greedyPointer == null) {
                this.greedyPointer = this.lib.whisper_full_default_params_by_ref(strategy.ordinal());
            }
            pointer = this.greedyPointer;
        } else {
            if (this.beamPointer == null) {
                this.beamPointer = this.lib.whisper_full_default_params_by_ref(strategy.ordinal());
            }
            pointer = this.beamPointer;
        }
        WhisperFullParams params = new WhisperFullParams(pointer);
        params.read();
        return params;
    }

    @Override
    public void close() {
        this.freeContext();
        this.freeParams();
        System.out.println("Whisper closed");
    }

    private void freeContext() {
        if (this.ctx != null) {
            this.lib.whisper_free(this.ctx);
        }
    }

    private void freeParams() {
        if (this.greedyPointer != null) {
            Native.free((long)Pointer.nativeValue((Pointer)this.greedyPointer));
            this.greedyPointer = null;
        }
        if (this.beamPointer != null) {
            Native.free((long)Pointer.nativeValue((Pointer)this.beamPointer));
            this.beamPointer = null;
        }
    }

    public String fullTranscribe(WhisperFullParams whisperParams, float[] audioData) throws IOException {
        if (this.ctx == null) {
            throw new IllegalStateException("Model not initialised");
        }
        if (this.lib.whisper_full(this.ctx, whisperParams, audioData, audioData.length) != 0) {
            throw new IOException("Failed to process audio");
        }
        int nSegments = this.lib.whisper_full_n_segments(this.ctx);
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < nSegments; ++i) {
            String text = this.lib.whisper_full_get_segment_text(this.ctx, i);
            System.out.println("Segment:" + text);
            str.append(text);
        }
        return str.toString().trim();
    }

    public List<WhisperSegment> fullTranscribeWithTime(WhisperFullParams whisperParams, float[] audioData) throws IOException {
        if (this.ctx == null) {
            throw new IllegalStateException("Model not initialised");
        }
        if (this.lib.whisper_full(this.ctx, whisperParams, audioData, audioData.length) != 0) {
            throw new IOException("Failed to process audio");
        }
        int nSegments = this.lib.whisper_full_n_segments(this.ctx);
        ArrayList<WhisperSegment> segments = new ArrayList<WhisperSegment>(nSegments);
        for (int i = 0; i < nSegments; ++i) {
            long t0 = this.lib.whisper_full_get_segment_t0(this.ctx, i);
            String text = this.lib.whisper_full_get_segment_text(this.ctx, i);
            long t1 = this.lib.whisper_full_get_segment_t1(this.ctx, i);
            segments.add(new WhisperSegment(t0, t1, text));
        }
        return segments;
    }

    public String getSystemInfo() {
        return this.lib.whisper_print_system_info();
    }

    public int benchMemcpy(int nthread) {
        return this.lib.whisper_bench_memcpy(nthread);
    }

    public int benchGgmlMulMat(int nthread) {
        return this.lib.whisper_bench_ggml_mul_mat(nthread);
    }
}

