/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver.log.syslog;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.nesscomputing.syslog4j.SyslogFacility;
import java.util.List;
import java.util.Set;
import org.skife.config.Config;
import org.skife.config.Default;
import org.skife.config.DefaultNull;

public abstract class SyslogRequestLogConfig {
    public static final String REQUEST_LOG_FIELDS_DEFAULT = "responseHeader:X-Trumpet-Track,remoteAddr,requestHeader:Authorization,method,requestUri,query,responseCode,responseHeader:Content-Length,elapsedTime";

    @Config(value={"blacklist"})
    @Default(value="/selftest, /application.wadl")
    public Set<String> getBlacklist() {
        return ImmutableSet.of((Object)"/selftest", (Object)"/application.wadl");
    }

    @Config(value={"enabled"})
    @Default(value="false")
    public boolean isEnabled() {
        return false;
    }

    @Config(value={"fields"})
    @Default(value="responseHeader:X-Trumpet-Track,remoteAddr,requestHeader:Authorization,method,requestUri,query,responseCode,responseHeader:Content-Length,elapsedTime")
    public List<String> getLogFields() {
        return ImmutableList.copyOf((Iterable)Splitter.on((String)",").split((CharSequence)REQUEST_LOG_FIELDS_DEFAULT));
    }

    @Config(value={"facility"})
    @Default(value="local0")
    public SyslogFacility getFacility() {
        return SyslogFacility.local0;
    }

    @Config(value={"protocol"})
    @Default(value="udp")
    public String getProtocol() {
        return "udp";
    }

    @Config(value={"syslog-host"})
    @Default(value="localhost")
    public String getSyslogHost() {
        return "localhost";
    }

    @Config(value={"syslog-port"})
    @Default(value="514")
    public int getSyslogPort() {
        return 514;
    }

    @Config(value={"charset"})
    @Default(value="UTF-8")
    public String getCharset() {
        return "UTF-8";
    }

    @Config(value={"hostname"})
    @DefaultNull
    public String getHostname() {
        return null;
    }

    @Config(value={"appname"})
    @DefaultNull
    public String getAppname() {
        return null;
    }

    @Config(value={"iana-identifier"})
    @Default(value="12345")
    public int getIanaIdentifier() {
        return 12345;
    }

    @Config(value={"max-msg-len"})
    @Default(value="1023")
    public int getMaxMessageLength() {
        return 1023;
    }
}

