/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver.log.log4j;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.nesscomputing.httpserver.log.LogFields;
import com.nesscomputing.httpserver.log.log4j.Log4jRequestLogConfig;
import com.nesscomputing.logging.Log;
import java.util.Map;
import java.util.Set;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.MDC;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.component.AbstractLifeCycle;

@Singleton
public class Log4jRequestLog
extends AbstractLifeCycle
implements RequestLog {
    private final Log log;
    private final String pattern;
    private final Set<String> blackList;
    private final Map<String, LogFields.LogField> knownFields;

    @Inject
    public Log4jRequestLog(Log4jRequestLogConfig config, Map<String, LogFields.LogField> knownFields) {
        this.pattern = config.getLogFields();
        this.log = Log.forName((String)config.getLoggerName());
        this.blackList = config.getBlacklist();
        this.knownFields = knownFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(Request request, Response response) {
        String requestUri = request.getRequestURI();
        for (String blackListEntry : this.blackList) {
            if (!StringUtils.startsWith((CharSequence)requestUri, (CharSequence)blackListEntry)) continue;
            return;
        }
        StringTemplate template = new StringTemplate(this.pattern);
        for (Map.Entry<String, LogFields.LogField> field : this.knownFields.entrySet()) {
            template.setAttribute(field.getKey(), (Object)ObjectUtils.toString((Object)field.getValue().log(request, response, null)));
        }
        try {
            MDC.put((String)"track", (Object)ObjectUtils.toString((Object)response.getHeader("X-Trumpet-Track")));
            this.log.info(template.toString());
        }
        finally {
            MDC.remove((String)"track");
        }
    }
}

