/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.httpserver;

import com.google.common.base.Charsets;
import com.google.common.net.MediaType;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.Stage;
import com.google.inject.name.Named;
import com.google.inject.servlet.ServletModule;
import com.nesscomputing.config.Config;
import com.nesscomputing.config.ConfigModule;
import com.nesscomputing.galaxy.GalaxyConfigModule;
import com.nesscomputing.httpclient.HttpClient;
import com.nesscomputing.httpclient.HttpClientObserverGroup;
import com.nesscomputing.httpclient.HttpClientResponse;
import com.nesscomputing.httpclient.HttpClientResponseHandler;
import com.nesscomputing.httpclient.guice.HttpClientModule;
import com.nesscomputing.httpserver.HttpServerModule;
import com.nesscomputing.lifecycle.Lifecycle;
import com.nesscomputing.lifecycle.LifecycleStage;
import com.nesscomputing.lifecycle.guice.LifecycleModule;
import com.nesscomputing.testing.lessio.AllowNetworkAccess;
import com.nesscomputing.testing.lessio.AllowNetworkListen;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jpountz.lz4.LZ4BlockInputStream;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@AllowNetworkListen(ports={0})
@AllowNetworkAccess(endpoints={"127.0.0.1:0"})
public class TestHttpCompression {
    private static final String BIG_CONTENT_RESOURCE = "/test-resources/big-content.txt";
    @Inject
    @Named(value="test")
    private final HttpClient httpClient = null;
    @Inject
    private final Lifecycle lifecycle = null;
    private String baseUri = null;
    private int port = 0;
    private static final String BIG_CONTENT;

    @Before
    public void setUp() throws Exception {
        this.port = TestHttpCompression.findUnusedPort();
        Assert.assertFalse((this.port == 0 ? 1 : 0) != 0);
        this.baseUri = String.format("http://localhost:%d/", this.port);
        Config config = Config.getFixedConfig((String[])new String[]{"galaxy.internal.port.http", Integer.toString(this.port)});
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new ConfigModule(config), new HttpServerModule(config), new HttpClientModule("test", new HttpClientObserverGroup[0]), new LifecycleModule(), new GalaxyConfigModule(), new ServletModule(){

            public void configureServlets() {
                this.binder().requireExplicitBindings();
                this.binder().disableCircularProxies();
                this.bind(ContentServlet.class);
                this.serve("/content", new String[0]).with(ContentServlet.class);
            }
        }});
        injector.injectMembers((Object)this);
        this.lifecycle.executeTo(LifecycleStage.START_STAGE);
    }

    @After
    public void teardown() {
        this.lifecycle.executeTo(LifecycleStage.STOP_STAGE);
    }

    private static int findUnusedPort() throws IOException {
        int port;
        try (ServerSocket socket = new ServerSocket();){
            socket.bind(new InetSocketAddress(0));
            port = socket.getLocalPort();
        }
        return port;
    }

    @Test
    public void testGzip() throws Exception {
        String content = (String)this.httpClient.get(this.baseUri + "/content", (HttpClientResponseHandler)new GzipHttpClientResponseHandler()).addHeader("Accept-Encoding", "gzip").perform();
        Assert.assertEquals((Object)BIG_CONTENT, (Object)content);
    }

    @Test
    public void testLZ4() throws Exception {
        String content = (String)this.httpClient.get(this.baseUri + "/content", (HttpClientResponseHandler)new LZ4HttpClientResponseHandler()).addHeader("Accept-Encoding", "lz4").perform();
        Assert.assertEquals((Object)BIG_CONTENT, (Object)content);
    }

    static {
        try {
            BIG_CONTENT = IOUtils.toString((InputStream)TestHttpCompression.class.getResourceAsStream(BIG_CONTENT_RESOURCE));
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    static class LZ4HttpClientResponseHandler
    implements HttpClientResponseHandler<String> {
        LZ4HttpClientResponseHandler() {
        }

        public String handle(HttpClientResponse response) throws IOException {
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertEquals((Object)"lz4", (Object)response.getHeader("Content-Encoding"));
            return IOUtils.toString((InputStream)new LZ4BlockInputStream(response.getResponseBodyAsStream()), (Charset)Charsets.UTF_8);
        }
    }

    static class GzipHttpClientResponseHandler
    implements HttpClientResponseHandler<String> {
        GzipHttpClientResponseHandler() {
        }

        public String handle(HttpClientResponse response) throws IOException {
            Assert.assertEquals((long)200L, (long)response.getStatusCode());
            Assert.assertEquals((Object)"gzip", (Object)response.getHeader("Content-Encoding"));
            return IOUtils.toString((InputStream)new GZIPInputStream(response.getResponseBodyAsStream()), (Charset)Charsets.UTF_8);
        }
    }

    @Singleton
    static class ContentServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;
        private ServletConfig config;

        ContentServlet() {
        }

        public void init(ServletConfig configIn) throws ServletException {
            this.config = configIn;
        }

        public ServletConfig getServletConfig() {
            return this.config;
        }

        public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
            res.setStatus(200);
            res.setContentType(MediaType.PLAIN_TEXT_UTF_8.toString());
            IOUtils.copy((InputStream)TestHttpCompression.class.getResourceAsStream(TestHttpCompression.BIG_CONTENT_RESOURCE), (OutputStream)res.getOutputStream());
        }

        public String getServletInfo() {
            return "Content Servlet";
        }

        public void destroy() {
        }
    }
}

