/*
 * Decompiled with CFR 0.152.
 */
package com.nosolojava.fsm.impl.runtime.basic;

import com.nosolojava.fsm.runtime.Event;
import com.nosolojava.fsm.runtime.EventType;
import java.net.URI;
import java.net.URISyntaxException;

public class BasicEvent
implements Event {
    private final String name;
    private final EventType eventType;
    private final String sendId;
    private final URI origin;
    private final String originType;
    private final String invokeId;
    private final Object data;
    private static URI INTERNAL_URI;

    public BasicEvent(String name) {
        this(name, null);
    }

    public BasicEvent(String name, Object data) {
        this(name, data, "");
    }

    public BasicEvent(String name, Object data, String invokeId) {
        this(name, EventType.INTERNAL, "", INTERNAL_URI, "", invokeId, data);
    }

    public BasicEvent(String name, EventType eventType, String sendId, URI origin, String originType, String invokeId, Object data) {
        this.name = name;
        this.eventType = eventType;
        this.sendId = sendId;
        this.origin = origin;
        this.originType = originType;
        this.invokeId = invokeId;
        this.data = data;
    }

    public static Event createPlatforEvent(String eventName, URI origin, Object data) {
        BasicEvent result = new BasicEvent(eventName, EventType.PLATFORM, "", origin, "scxml", "", data);
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicEvent other = (BasicEvent)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "BasicEvent [name=" + this.name + ", eventType=" + this.eventType + ", sendId=" + this.sendId + ", origin=" + this.origin + ", originType=" + this.originType + ", invokeId=" + this.invokeId + ", data=" + this.data + "]";
    }

    public <T> T getData() {
        return (T)this.data;
    }

    public String getName() {
        return this.name;
    }

    public String getInvokeId() {
        return this.invokeId;
    }

    public EventType getType() {
        return this.eventType;
    }

    public String getSendId() {
        return this.sendId;
    }

    public URI getOrigin() {
        return this.origin;
    }

    public String getOriginType() {
        return this.originType;
    }

    static {
        try {
            INTERNAL_URI = new URI("#_internal");
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }
}

