/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.utility;

import com.scriptbasic.errors.BasicInterpreterInternalError;
import com.scriptbasic.executors.rightvalues.AbstractNumericRightValue;
import com.scriptbasic.executors.rightvalues.AbstractPrimitiveRightValue;
import com.scriptbasic.executors.rightvalues.BasicBooleanValue;
import com.scriptbasic.executors.rightvalues.BasicDoubleValue;
import com.scriptbasic.executors.rightvalues.BasicJavaObjectValue;
import com.scriptbasic.executors.rightvalues.BasicLongValue;
import com.scriptbasic.executors.rightvalues.BasicStringValue;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.interfaces.ExecutionException;
import com.scriptbasic.interfaces.RightValue;
import com.scriptbasic.utility.UtilityUtility;

public final class RightValueUtility {
    private RightValueUtility() {
        UtilityUtility.throwExceptionToEnsureNobodyCallsIt();
    }

    public static Object getValueObject(RightValue arg) {
        if (!(arg instanceof AbstractPrimitiveRightValue)) {
            throw new BasicInterpreterInternalError("The class of the object " + arg + " is not convertible type to fetchs it's value as object.");
        }
        Object object = ((AbstractPrimitiveRightValue)arg).getValue();
        return object;
    }

    public static Integer convert2Integer(RightValue index) throws ExecutionException {
        Integer result = 0;
        if (!index.isNumeric().booleanValue()) {
            throw new BasicRuntimeException(index.toString() + " is not a numeric value, can not be used to index and array");
        }
        result = ((Number)((AbstractNumericRightValue)index).getValue()).intValue();
        return result;
    }

    public static RightValue createRightValue(Object value) {
        RightValue rightValue = null;
        rightValue = value instanceof RightValue ? (RightValue)value : (value instanceof Double ? new BasicDoubleValue((Double)value) : (value instanceof Float ? new BasicDoubleValue(((Float)value).doubleValue()) : (value instanceof Long ? new BasicLongValue((Long)value) : (value instanceof Integer ? new BasicLongValue(((Integer)value).longValue()) : (value instanceof Short ? new BasicLongValue(((Short)value).longValue()) : (value instanceof Byte ? new BasicLongValue(((Byte)value).longValue()) : (value instanceof String ? new BasicStringValue((String)value) : (value instanceof Character ? new BasicStringValue(new String(new char[]{((Character)value).charValue()})) : (value instanceof Boolean ? new BasicBooleanValue((Boolean)value) : new BasicJavaObjectValue(value))))))))));
        return rightValue;
    }

    public static RightValue[] createRightValues(Object[] values) {
        if (values != null) {
            RightValue[] rightValues = new RightValue[values.length];
            for (int i = 0; i < values.length; ++i) {
                rightValues[i] = RightValueUtility.createRightValue(values[i]);
            }
            return rightValues;
        }
        return null;
    }
}

