/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.javax.script;

import com.scriptbasic.factories.FactoryFactory;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.ExecutionException;
import com.scriptbasic.interfaces.ExtendedInterpreter;
import com.scriptbasic.interfaces.Factory;
import com.scriptbasic.interfaces.LexicalAnalyzer;
import com.scriptbasic.readers.GenericReader;
import com.scriptbasic.utility.FactoryUtility;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public class ScriptEngine
extends AbstractScriptEngine {
    private Factory factory;
    private ScriptEngineFactory scriptEngineFactory;

    public Factory getBasicFactory() {
        return this.factory;
    }

    public ScriptEngine(ScriptEngineFactory scriptEngineFactory) {
        this.scriptEngineFactory = scriptEngineFactory;
        this.factory = FactoryFactory.getFactory();
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        StringReader reader = new StringReader(script);
        return this.eval((Reader)reader, context);
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        ExtendedInterpreter interpreter = FactoryUtility.getExtendedInterpreter(this.factory);
        try {
            ScriptEngine.mergeBinding(interpreter, context.getBindings(200));
            ScriptEngine.mergeBinding(interpreter, context.getBindings(100));
            this.execute(reader, this.getContext().getReader(), this.getContext().getWriter(), this.getContext().getErrorWriter());
            ScriptEngine.unmergeBindings(interpreter, context.getBindings(100));
            ScriptEngine.unmergeBindings(interpreter, context.getBindings(200));
        }
        catch (ExecutionException e) {
            throw new ScriptException(e);
        }
        catch (AnalysisException e) {
            throw new ScriptException(e);
        }
        return null;
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.scriptEngineFactory;
    }

    private void execute(Reader r, Reader input, Writer output, Writer error) throws AnalysisException, ExecutionException {
        GenericReader reader = new GenericReader();
        reader.set(r);
        reader.setSourceProvider(null);
        reader.set((String)null);
        LexicalAnalyzer lexicalAnalyzer = FactoryUtility.getLexicalAnalyzer(this.factory);
        lexicalAnalyzer.set(reader);
        ExtendedInterpreter interpreter = FactoryUtility.getExtendedInterpreter(this.factory);
        interpreter.setProgram(FactoryUtility.getSyntaxAnalyzer(this.factory).analyze());
        interpreter.setWriter(output);
        interpreter.setErrorWriter(error);
        interpreter.setReader(input);
        interpreter.execute();
    }

    private static void unmergeBindings(ExtendedInterpreter interpreter, Bindings bindings) throws ExecutionException {
        for (String name : bindings.keySet()) {
            bindings.put(name, interpreter.getVariable(name));
        }
    }

    private static void mergeBinding(ExtendedInterpreter interpreter, Bindings bindings) throws ExecutionException {
        for (String name : bindings.keySet()) {
            interpreter.setVariable(name, bindings.get(name));
        }
    }
}

