/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.utility.functions;

import com.scriptbasic.api.BasicFunction;
import com.scriptbasic.classification.Constant;
import com.scriptbasic.classification.String;
import com.scriptbasic.classification.System;
import com.scriptbasic.classification.Utility;
import com.scriptbasic.executors.rightvalues.BasicArrayValue;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.log.Logger;
import com.scriptbasic.log.LoggerFactory;
import com.scriptbasic.utility.MagicBean;
import com.scriptbasic.utility.NoInstance;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;

public class UtilityFunctions {
    private static final Logger BASIC_LOGGER = LoggerFactory.getBasicLogger();

    private UtilityFunctions() {
        NoInstance.isPossible();
    }

    @BasicFunction(alias="newRecord", classification={System.class})
    public static Object newMagicBean() {
        return new MagicBean();
    }

    @BasicFunction(classification={System.class})
    public static void logError(java.lang.String message) {
        BASIC_LOGGER.error(message);
    }

    @BasicFunction(classification={System.class})
    public static void logInfo(java.lang.String message) {
        BASIC_LOGGER.info(message, new Object[0]);
    }

    @BasicFunction(classification={System.class})
    public static void logDebug(java.lang.String message) {
        BASIC_LOGGER.debug(message, new Object[0]);
    }

    @BasicFunction(classification={Constant.class})
    public static Object undef() {
        return null;
    }

    @BasicFunction(classification={Constant.class})
    public static Boolean isUndef(Object s) {
        return s == null;
    }

    @BasicFunction(classification={Constant.class})
    public static Boolean isDefined(Object s) {
        return s != null;
    }

    @BasicFunction(classification={Utility.class})
    public static byte[] byteBuffer(int len) {
        return new byte[len];
    }

    @BasicFunction(classification={Utility.class})
    public static Long getByte(byte[] buffer, Long i) {
        if (i < 0L || i >= (long)buffer.length) {
            return null;
        }
        return buffer[i.intValue()];
    }

    @BasicFunction(classification={Utility.class})
    public static void setByte(byte[] buffer, Long i, Long v) throws BasicRuntimeException {
        if (v < 0L && v > -128L) {
            v = v + 128L;
        }
        if (v < 0L || v > 255L) {
            throw new BasicRuntimeException("Byte value is out of range.");
        }
        if (i < 0L && i >= (long)buffer.length) {
            throw new BasicRuntimeException("Index out of range indexing a byte array from BASIC");
        }
        buffer[i.intValue()] = (byte)v.intValue();
    }

    @BasicFunction(classification={Utility.class})
    public static byte[] getStringBytes(java.lang.String s) throws UnsupportedEncodingException {
        return s.getBytes("utf-8");
    }

    @BasicFunction(classification={Utility.class, String.class})
    public static java.lang.String stringifyBuffer(byte[] buffer) throws UnsupportedEncodingException {
        return new java.lang.String(buffer, "utf-8");
    }

    @BasicFunction(classification={Utility.class}, requiredVersion=2L)
    public static Long length(Object arg) {
        if (arg == null) {
            return null;
        }
        if (arg instanceof BasicArrayValue) {
            BasicArrayValue array = (BasicArrayValue)arg;
            return array.getLength();
        }
        if (arg instanceof java.lang.String) {
            java.lang.String string = (java.lang.String)arg;
            return string.length();
        }
        if (arg.getClass().isArray()) {
            return Array.getLength(arg);
        }
        return null;
    }
}

