/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.syntax.commands;

import com.scriptbasic.context.Context;
import com.scriptbasic.executors.leftvalues.BasicLeftValue;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.BasicSyntaxException;
import com.scriptbasic.interfaces.CommandAnalyzer;
import com.scriptbasic.interfaces.Expression;
import com.scriptbasic.interfaces.ExpressionList;
import com.scriptbasic.interfaces.LexicalElement;
import com.scriptbasic.interfaces.NestedStructure;
import com.scriptbasic.spi.Command;
import com.scriptbasic.spi.LeftValue;
import com.scriptbasic.spi.LeftValueList;
import com.scriptbasic.syntax.AbstractAnalyzer;
import com.scriptbasic.utility.SyntaxExceptionUtility;

public abstract class AbstractCommandAnalyzer
extends AbstractAnalyzer<Command>
implements CommandAnalyzer {
    protected final Context ctx;

    protected AbstractCommandAnalyzer(Context ctx) {
        this.ctx = ctx;
    }

    protected static boolean equal(LeftValue a, LeftValue b) {
        if (a == b || a != null && a.equals(b)) {
            return true;
        }
        if (a instanceof BasicLeftValue && b instanceof BasicLeftValue) {
            BasicLeftValue aBasic = (BasicLeftValue)a;
            BasicLeftValue bBasic = (BasicLeftValue)b;
            if (aBasic.hasModifiers() || bBasic.hasModifiers()) {
                return false;
            }
            return aBasic.getIdentifier() != null && aBasic.getIdentifier().equals(bBasic.getIdentifier());
        }
        return false;
    }

    protected String getName() {
        return this.getClass().getSimpleName().substring(15).toUpperCase();
    }

    protected LeftValueList analyzeSimpleLeftValueList() throws AnalysisException {
        return (LeftValueList)this.ctx.simpleLeftValueListAnalyzer.analyze();
    }

    protected LeftValue analyzeSimpleLeftValue() throws AnalysisException {
        return (LeftValue)this.ctx.simpleLeftValueAnalyzer.analyze();
    }

    protected Expression analyzeExpression() throws AnalysisException {
        return this.ctx.expressionAnalyzer.analyze();
    }

    protected ExpressionList analyzeExpressionList() throws AnalysisException {
        return (ExpressionList)this.ctx.expressionListAnalyzer.analyze();
    }

    protected void pushNode(NestedStructure node) {
        this.ctx.nestedStructureHouseKeeper.push(node);
    }

    protected void assertKeyWord(String keyword) throws AnalysisException {
        if (!this.isKeyWord(keyword)) {
            LexicalElement lexicalElement = this.ctx.lexicalAnalyzer.peek();
            throw new BasicSyntaxException("There is no '" + keyword + "' after the '" + this.getName() + "'", lexicalElement, null);
        }
        this.ctx.lexicalAnalyzer.get();
    }

    protected boolean isKeyWord(String keyword) throws AnalysisException {
        LexicalElement lexicalElement = this.ctx.lexicalAnalyzer.peek();
        return lexicalElement != null && lexicalElement.isSymbol(keyword) != false;
    }

    protected void consumeEndOfLine() throws AnalysisException {
        LexicalElement le = this.ctx.lexicalAnalyzer.get();
        if (le != null && !le.isLineTerminator().booleanValue()) {
            SyntaxExceptionUtility.throwSyntaxException("There are extra characters following the expression after the '" + this.getName() + "' keyword", le);
        }
    }
}

