/*
 * Decompiled with CFR 0.152.
 */
package com.securenative;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.securenative.Logger;
import com.securenative.actions.ActionManager;
import com.securenative.actions.ApiRoute;
import com.securenative.configurations.AgentConfigOptions;
import com.securenative.configurations.ConfigurationUpdaterRunnable;
import com.securenative.configurations.HeartBeatRunnable;
import com.securenative.configurations.SecureNativeOptions;
import com.securenative.events.Event;
import com.securenative.events.EventFactory;
import com.securenative.events.SnEventManager;
import com.securenative.exceptions.SecureNativeSDKException;
import com.securenative.interceptors.InterceptorManager;
import com.securenative.models.AgentLoginResponse;
import com.securenative.models.EventTypes;
import com.securenative.models.RiskResult;
import com.securenative.module.ModuleManager;
import com.securenative.rules.RuleManager;
import com.securenative.utils.Utils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class SecureNative {
    private final String API_URL = "https://api.securenative.com/collector/api/v1";
    private final int INTERVAL = 1000;
    private final int MAX_EVENTS = 1000;
    private final Boolean AUTO_SEND = true;
    private final Boolean SDK_ENABLED = true;
    private final Boolean DEBUG_LOG = false;
    private final int DEFAULT_TIMEOUT = 1500;
    private Boolean isAgentStarted = false;
    private SnEventManager eventManager;
    private SecureNativeOptions snOptions;
    private String apiKey;
    private Utils utils;
    private ObjectMapper mapper;
    private long configUpdateTs = 0L;
    private ConfigurationUpdaterRunnable configurationUpdater;
    private HeartBeatRunnable heartBeatManager;
    public ModuleManager moduleManager;

    public SecureNative(ModuleManager moduleManager, SecureNativeOptions snOptions) throws SecureNativeSDKException {
        this.apiKey = snOptions.getApiKey();
        this.utils = new Utils();
        this.snOptions = this.initializeOptions(snOptions);
        Logger.setLoggingEnable(this.snOptions.getDebugMode());
        this.eventManager = new SnEventManager(this.apiKey, this.snOptions);
        this.moduleManager = moduleManager;
        this.snOptions = snOptions;
        this.mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        if (!this.snOptions.isAgentDisable().booleanValue()) {
            InterceptorManager.applyModuleInterceptors(this.moduleManager, this);
        }
    }

    private SecureNativeOptions initializeOptions(SecureNativeOptions options) {
        if (options == null) {
            Logger.getLogger().info("SecureNative options are empty, initializing default values");
            options = new SecureNativeOptions();
        }
        if (Utils.isNullOrEmpty(options.getApiUrl())) {
            options.setApiUrl("https://api.securenative.com/collector/api/v1");
        }
        if (options.getInterval() == 0) {
            options.setInterval(1000);
        }
        if (options.getMaxEvents() == 0L) {
            options.setMaxEvents(1000L);
        }
        if (options.isAutoSend() == null) {
            options.setAutoSend(this.AUTO_SEND);
        }
        if (options.getSdkEnabled() == null) {
            options.setSdkEnabled(this.SDK_ENABLED);
        }
        if (options.getDebugMode() == null) {
            options.setSdkEnabled(this.DEBUG_LOG);
        }
        if (options.getTimeout() == 0L) {
            options.setTimeout(1500L);
        }
        if (options.getDebugMode() == null) {
            options.setDebugMode(false);
        }
        return options;
    }

    private void handleConfigUpdate(AgentConfigOptions config) {
        Logger.getLogger().debug("Handling config update");
        if (config == null) {
            return;
        }
        if (config.getTs() > this.configUpdateTs) {
            this.configUpdateTs = config.getTs();
        }
        if (config.getRules() != null) {
            RuleManager.enforceRules(config.getRules());
        }
        if (config.getActions() != null) {
            ActionManager.enforceActions(config.getActions());
        }
    }

    public void error(Error err) {
        Logger.getLogger().debug("Error", (Throwable)err);
        String requestUrl = String.format("%s/%s", new Object[]{this.snOptions.getApiUrl(), ApiRoute.ERROR});
        Event event = EventFactory.createEvent(EventTypes.ERROR, err.toString());
        this.eventManager.sendAsync(event, requestUrl);
    }

    public String getDefaultCookieName() {
        return this.utils.COOKIE_NAME;
    }

    public String agentLogin() {
        Logger.getLogger().debug("Performing agent login");
        String loginRequestUrl = this.snOptions.getApiUrl() + "/agent-login";
        String framework = this.moduleManager.getFramework();
        String frameworkVersion = this.moduleManager.getFrameworkVersion();
        Event loginEvent = EventFactory.createEvent(EventTypes.AGENT_LOG_IN, framework, frameworkVersion, this.snOptions.getAppName());
        try {
            String r = this.eventManager.sendAgentEvent(loginEvent, loginRequestUrl);
            AgentLoginResponse res = (AgentLoginResponse)this.mapper.readValue(r, AgentLoginResponse.class);
            this.handleConfigUpdate(res.config);
            String heartbeatRequestUrl = String.format("%s/%s", new Object[]{this.snOptions.getApiUrl(), ApiRoute.HEARTBEAT});
            Event heartbeatEvent = EventFactory.createEvent(EventTypes.ERROR, this.snOptions.getAppName());
            this.heartBeatManager = new HeartBeatRunnable(this.eventManager, heartbeatRequestUrl, heartbeatEvent, this.snOptions.getHeartBeatInterval());
            this.heartBeatManager.run();
            String confRequestUrl = String.format("%s/%s", new Object[]{this.snOptions.getApiUrl(), ApiRoute.CONFIG});
            Event confEvent = EventFactory.createEvent(EventTypes.CONFIG, this.snOptions.getHostId(), this.snOptions.getAppName());
            this.configurationUpdater = new ConfigurationUpdaterRunnable(this.eventManager, confRequestUrl, confEvent, this.configUpdateTs);
            this.configurationUpdater.run();
            if (res.getSessionId().toLowerCase().equals("invalid api key id")) {
                Logger.getLogger().debug("Failed to perform agent login: Invalid api key id");
                return null;
            }
            Logger.getLogger().debug(String.format("Agent successfully logged-in, sessionId: %s", res.getSessionId()));
            return res.getSessionId();
        }
        catch (Exception e) {
            Logger.getLogger().debug(String.format("Failed to perform agent login: %s", e.toString()));
            return null;
        }
    }

    public Boolean agentLogout() {
        Logger.getLogger().debug("Performing agent logout");
        String requestUrl = this.snOptions.getApiUrl() + "/agent-logout";
        Event event = EventFactory.createEvent(EventTypes.AGENT_LOG_OUT, new String[0]);
        try {
            this.eventManager.sendAgentEvent(event, requestUrl);
            if (this.configurationUpdater.isRunning()) {
                this.configurationUpdater.interrupt();
            }
            if (this.heartBeatManager.isRunning()) {
                this.heartBeatManager.interrupt();
            }
            Logger.getLogger().debug("Agent successfully logged-out");
            return true;
        }
        catch (Exception e) {
            Logger.getLogger().debug(String.join((CharSequence)"Failed to perform agent logout; ", e.toString()));
            return false;
        }
    }

    public void startAgent() {
        block7: {
            if (!this.isAgentStarted.booleanValue()) {
                Logger.getLogger().debug("Attempting to start agent");
                if (this.snOptions.getApiKey() == null) {
                    Logger.getLogger().error("You must pass your SecureNative api key");
                    return;
                }
                if (this.snOptions.isAgentDisable().booleanValue()) {
                    Logger.getLogger().debug("Skipping agent start");
                    return;
                }
                try {
                    String sessionId = this.agentLogin();
                    if (sessionId != null) {
                        sessionId = this.parseSessionId(sessionId);
                        InterceptorManager.applyAgentInterceptor(sessionId);
                        this.isAgentStarted = true;
                        Logger.getLogger().debug("Agent successfully started!");
                        break block7;
                    }
                    Logger.getLogger().debug("No session obtained, unable to start agent!");
                }
                catch (Exception e) {
                    long backoff = (long)(Math.ceil(Math.random() * 10.0) + 1.0) * 1000L;
                    Logger.getLogger().debug(String.format("Failed to start agent, will retry after backoff %s", backoff));
                    CompletableFuture.delayedExecutor(backoff, TimeUnit.MILLISECONDS).execute(this::startAgent);
                }
            } else {
                Logger.getLogger().debug("Agent already started, skipping");
            }
        }
    }

    public void stopAgent() {
        if (this.isAgentStarted.booleanValue()) {
            Logger.getLogger().debug("Attempting to stop agent");
            Boolean status = this.agentLogout();
            if (status.booleanValue()) {
                this.isAgentStarted = false;
            }
        }
    }

    public void track(Event event) {
        Logger.getLogger().info("Track event call");
        this.eventManager.sendAsync(event, this.snOptions.getApiUrl() + "/track");
    }

    public RiskResult verify(Event event) {
        Logger.getLogger().info("Verify event call");
        return this.eventManager.sendSync(event, this.snOptions.getApiUrl() + "/verify");
    }

    public RiskResult flow(long flowId, Event event) {
        Logger.getLogger().info("Flow event call");
        return this.eventManager.sendSync(event, this.snOptions.getApiUrl() + "/flow/" + flowId);
    }

    public String getApiKey() {
        return this.apiKey;
    }

    private String parseSessionId(String sessionId) {
        JSONObject session = new JSONObject(sessionId);
        return session.getString("sessionId");
    }
}

