/*
 * Decompiled with CFR 0.152.
 */
package com.securenative.middleware;

import com.securenative.Logger;
import com.securenative.SecureNative;
import com.securenative.utils.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SpringVerifyWebhookMiddleware
implements Filter {
    private SecureNative secureNative;
    private final String SIGNATURE_KEY = "x-securenative";
    private Utils utils;

    public SpringVerifyWebhookMiddleware(SecureNative secureNative) {
        this.secureNative = secureNative;
        this.utils = new Utils();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String payload;
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse res = (HttpServletResponse)servletResponse;
        String signature = "";
        if (req != null && !Utils.isNullOrEmpty(req.getHeader("x-securenative"))) {
            signature = req.getHeader("x-securenative");
        }
        if (this.utils.isVerifiedSnRequest(payload = this.getBody(servletRequest), signature, this.secureNative.getApiKey())) {
            filterChain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        Logger.getLogger().info("Request have been blocked due to incompatible signature");
        res.sendError(401, "Unauthorized");
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBody(ServletRequest servletRequest) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = null;){
            ServletInputStream inputStream = servletRequest.getInputStream();
            if (inputStream != null) {
                int bytesRead;
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream));
                char[] charBuffer = new char[128];
                while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                    stringBuilder.append(charBuffer, 0, bytesRead);
                }
            }
        }
        return stringBuilder.toString();
    }
}

