/*
 * Decompiled with CFR 0.152.
 */
package com.securenative.events;

import com.securenative.events.Event;
import com.securenative.models.EventTypes;
import com.securenative.snpackage.PackageItem;
import com.securenative.snpackage.PackageManager;
import com.securenative.utils.Logger;
import com.securenative.utils.Utils;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class AgentHeartBeatEvent
implements Event {
    private static final String PACKAGE_FILE_NAME = "/pom.xml";
    private final String eventType = EventTypes.HEARTBEAT.getType();
    private String runtime;
    private String hostId;
    private String hostname;
    private String agentVersion;
    private String timestamp = Utils.generateTimestamp();
    private static PackageItem agentPackage = PackageManager.getPackage(System.getProperty("user.dir").concat("/pom.xml"));

    public AgentHeartBeatEvent() {
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
            this.hostId = Utils.calculateHash(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            Logger.getLogger().debug("Could not find host name; ", (Throwable)e);
        }
        this.agentVersion = agentPackage.getVersion();
        this.runtime = "java";
    }

    @Override
    public String getEventType() {
        return this.eventType;
    }

    public String getRuntime() {
        return this.runtime;
    }

    public String getHostId() {
        return this.hostId;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setRuntime(String runtime) {
        this.runtime = runtime;
    }

    public void setHostId(String hostId) {
        this.hostId = hostId;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setAgentVersion(String agentVersion) {
        this.agentVersion = agentVersion;
    }

    public static void setAgentPackage(PackageItem agentPackage) {
        AgentHeartBeatEvent.agentPackage = agentPackage;
    }
}

