/*
 * Decompiled with CFR 0.152.
 */
package com.securenative.processors;

import com.securenative.actions.Action;
import com.securenative.processors.BlacklistIp;
import com.securenative.processors.BlockRequest;
import com.securenative.processors.ChallengeRequest;
import com.securenative.processors.DeleteBlacklistedIp;
import com.securenative.processors.DeleteHeaders;
import com.securenative.processors.ModifyHeaders;
import com.securenative.processors.Processor;
import com.securenative.processors.ProcessorType;
import com.securenative.processors.WhitelistIp;
import com.securenative.rules.Rule;

public class ProcessorsFactory {
    public static Processor getRuleProcessor(String processor, Rule rule) {
        if (processor.equals(ProcessorType.DELETE_HEADERS.getType())) {
            return new DeleteHeaders(rule);
        }
        if (processor.equals(ProcessorType.MODIFY_HEADERS.getType())) {
            return new ModifyHeaders(rule);
        }
        if (processor.equals(ProcessorType.BLOCK_REQUEST.getType())) {
            return new BlockRequest();
        }
        if (processor.equals(ProcessorType.CHALLENGE_REQUEST.getType())) {
            return new ChallengeRequest();
        }
        return new Processor();
    }

    public static Processor getActionProcessor(String processor, Action action) {
        if (processor.equals(ProcessorType.BLACKLIST_IP.getType())) {
            return new BlacklistIp(action);
        }
        if (processor.equals(ProcessorType.DELETE_BLACKLISTED.getType())) {
            return new DeleteBlacklistedIp(action);
        }
        if (processor.equals(ProcessorType.WHITELIST_IP.getType())) {
            return new WhitelistIp(action);
        }
        return new Processor();
    }
}

