/*
 * Decompiled with CFR 0.152.
 */
package com.securenative.rules;

import com.securenative.processors.ProcessorsFactory;
import com.securenative.rules.Rule;
import com.securenative.rules.RuleData;
import com.securenative.rules.RuleInterception;
import java.util.ArrayList;
import java.util.List;

public class RuleManager {
    private static List<Rule> rules = new ArrayList<Rule>();

    public List<Rule> getAllRules() {
        return rules;
    }

    public List<Rule> getRules(String method) {
        ArrayList<Rule> r = new ArrayList<Rule>();
        for (Rule rule : rules) {
            if (!rule.getInterception().getMethod().equals(method)) continue;
            r.add(rule);
        }
        return r;
    }

    public void registerRule(Rule rule) {
        rules.add(rule);
    }

    public void clean() {
        rules.clear();
    }

    public void enforceRules(List<Rule> rules) {
        this.clean();
        for (Rule rule : rules) {
            RuleData data = rule.getData();
            RuleInterception interception = rule.getInterception();
            String module = interception.getModule();
            String method = interception.getMethod();
            String processor = interception.getProcessor();
            String[] m = method.split(":");
            String func = "";
            if (m != null && m.length > 0) {
                func = m[0];
            }
            Rule r = new Rule(data, new RuleInterception(module, func, processor));
            ProcessorsFactory.getRuleProcessor(processor, r).apply();
            this.registerRule(rule);
        }
    }
}

