/*
 * Decompiled with CFR 0.152.
 */
package com.securenative.utils;

import com.securenative.utils.Utils;
import java.util.Formatter;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SignatureUtils {
    public static final String SIGNATURE_HEADER = "x-securenative";
    private static final String HMAC_SHA512 = "HmacSHA512";

    private static String toHexString(byte[] bytes) {
        Formatter formatter = new Formatter();
        for (byte b : bytes) {
            formatter.format("%02x", b);
        }
        return formatter.toString();
    }

    private static String buildHmacSignature(String message, String key) {
        try {
            Mac hasher = Mac.getInstance(HMAC_SHA512);
            hasher.init(new SecretKeySpec(key.getBytes(), HMAC_SHA512));
            byte[] hash = hasher.doFinal(message.getBytes());
            return SignatureUtils.toHexString(hash);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static boolean isValidSignature(String headerSignature, String payload, String apiKey) {
        String signed = SignatureUtils.buildHmacSignature(payload, apiKey);
        if (Utils.isNullOrEmpty(signed).booleanValue() || Utils.isNullOrEmpty(headerSignature).booleanValue()) {
            return false;
        }
        return Utils.timingSafeEqual(headerSignature.getBytes(), signed.getBytes());
    }
}

