package com.shift4.request;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.shift4.response.Customer;

import java.util.HashMap;
import java.util.Map;

@JsonInclude(Include.NON_NULL)
public class CustomerListRequest {

	private Integer limit;
	private String startingAfterId;
	private String endingBeforeId;
	private Boolean includeTotalCount;

	private CreatedFilter created;
	private Boolean deleted;

	private String email;
	
	@JsonIgnore
	private final Map<String, Object> other = new HashMap<>();

	public Integer getLimit() {
		return limit;
	}

	public String getStartingAfterId() {
		return startingAfterId;
	}

	public String getEndingBeforeId() {
		return endingBeforeId;
	}

	public Boolean getIncludeTotalCount() {
		return includeTotalCount;
	}

	public CreatedFilter getCreated() {
		return created;
	}

	public Boolean getDeleted() {
		return deleted;
	}

	public String getEmail() {
		return email;
	}

	public CustomerListRequest limit(Integer limit) {
		this.limit = limit;
		return this;
	}

	public CustomerListRequest startingAfterId(String startingAfterId) {
		this.startingAfterId = startingAfterId;
		return this;
	}

	public CustomerListRequest startingAfter(Customer customer) {
		return startingAfterId(customer.getId());
	}

	public CustomerListRequest endingBeforeId(String endingBeforeId) {
		this.endingBeforeId = endingBeforeId;
		return this;
	}

	public CustomerListRequest endingBefore(Customer customer) {
		return endingBeforeId(customer.getId());
	}

	public CustomerListRequest includeTotalCount(Boolean includeTotalCount) {
		this.includeTotalCount = includeTotalCount;
		return this;
	}

	public CustomerListRequest includeTotalCount() {
		return includeTotalCount(true);
	}

	public CustomerListRequest created(CreatedFilter created) {
		this.created = created;
		return this;
	}

	public CustomerListRequest deleted(Boolean deleted) {
		this.deleted = deleted;
		return this;
	}

	public CustomerListRequest email(String email) {
		this.email = email;
		return this;
	}

	@JsonAnyGetter
	private Map<String, Object> getOtherMap() {
		return other;
	}

	@JsonAnySetter
	public CustomerListRequest set(String name, Object value) {
		other.put(name, value);
		return this;
	}
}
