/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.log.direct;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.stackify.api.EnvironmentDetail;
import com.stackify.api.LogMsg;
import com.stackify.api.StackifyError;
import com.stackify.api.WebRequestDetail;
import com.stackify.api.common.lang.Throwables;
import com.stackify.api.common.log.EventAdapter;
import com.stackify.api.common.log.ServletLogContext;
import com.stackify.api.common.log.direct.LogEvent;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

public class LogEventAdapter
implements EventAdapter<LogEvent> {
    private final EnvironmentDetail envDetail;

    public LogEventAdapter(EnvironmentDetail envDetail) {
        Preconditions.checkNotNull((Object)envDetail);
        this.envDetail = envDetail;
    }

    @Override
    public Optional<Throwable> getThrowable(LogEvent event) {
        return Optional.fromNullable((Object)event.getException());
    }

    @Override
    public StackifyError getStackifyError(LogEvent event, Throwable exception) {
        Optional<WebRequestDetail> webRequest;
        StackifyError.Builder builder = StackifyError.newBuilder();
        builder.environmentDetail(this.envDetail);
        builder.occurredEpochMillis(new Date(event.getTimestamp()));
        if (exception != null) {
            builder.error(Throwables.toErrorItem(event.getMessage(), exception));
        } else {
            builder.error(Throwables.toErrorItem(event.getMessage(), event.getClassName(), event.getMethodName(), event.getLineNumber()));
        }
        Optional<String> user = ServletLogContext.getUser();
        if (user.isPresent()) {
            builder.userName((String)user.get());
        }
        if ((webRequest = ServletLogContext.getWebRequest()).isPresent()) {
            builder.webRequestDetail((WebRequestDetail)webRequest.get());
        }
        builder.serverVariables((Map<String, String>)Maps.fromProperties((Properties)System.getProperties()));
        return builder.build();
    }

    @Override
    public LogMsg getLogMsg(LogEvent event, Optional<StackifyError> error) {
        Optional<String> transactionId;
        LogMsg.Builder builder = LogMsg.newBuilder();
        builder.msg(event.getMessage());
        builder.ex((StackifyError)error.orNull());
        builder.epochMs(event.getTimestamp());
        if (event.getLevel() != null) {
            builder.level(event.getLevel().toLowerCase());
        }
        if ((transactionId = ServletLogContext.getTransactionId()).isPresent()) {
            builder.transId((String)transactionId.get());
        }
        return builder.build();
    }

    @Override
    public boolean isErrorLevel(LogEvent event) {
        if (event.getLevel() != null) {
            return "ERROR".equals(event.getLevel().toUpperCase());
        }
        return false;
    }
}

