/*
 * Decompiled with CFR 0.152.
 */
package com.stackify.api.common.log;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.stackify.api.LogMsg;
import com.stackify.api.StackifyError;
import com.stackify.api.common.ApiConfiguration;
import com.stackify.api.common.AppIdentityService;
import com.stackify.api.common.error.ErrorGovernor;
import com.stackify.api.common.log.EventAdapter;
import com.stackify.api.common.log.LogBackgroundService;
import com.stackify.api.common.log.LogCollector;
import com.stackify.api.common.log.LogTransport;
import com.stackify.api.common.log.LogTransportAgentSocket;
import com.stackify.api.common.log.LogTransportDirect;
import com.stackify.api.common.mask.Masker;
import com.stackify.api.common.util.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogAppender<T>
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogAppender.class);
    private static final String COM_DOT_STACKIFY = "com.stackify.";
    private final String logger;
    private final EventAdapter<T> eventAdapter;
    private LogCollector collector = null;
    private LogBackgroundService backgroundService = null;
    private final ErrorGovernor errorGovernor = new ErrorGovernor();
    private final Masker masker;
    private final boolean skipJson;
    private boolean allowComDotStackify = false;

    public LogAppender(@NonNull String logger, @NonNull EventAdapter<T> eventAdapter, Masker masker, boolean skipJson) {
        if (logger == null) {
            throw new NullPointerException("logger is marked non-null but is null");
        }
        if (eventAdapter == null) {
            throw new NullPointerException("eventAdapter is marked non-null but is null");
        }
        this.logger = logger;
        this.eventAdapter = eventAdapter;
        this.masker = masker;
        this.skipJson = skipJson;
    }

    public LogAppender(@NonNull String logger, @NonNull EventAdapter<T> eventAdapter, Masker masker) {
        this(logger, eventAdapter, masker, false);
        if (logger == null) {
            throw new NullPointerException("logger is marked non-null but is null");
        }
        if (eventAdapter == null) {
            throw new NullPointerException("eventAdapter is marked non-null but is null");
        }
    }

    public void activate(ApiConfiguration apiConfig) {
        Preconditions.checkNotNull(apiConfig);
        Preconditions.checkNotNull(apiConfig.getApiUrl());
        Preconditions.checkArgument(!apiConfig.getApiUrl().isEmpty());
        Preconditions.checkNotNull(apiConfig.getApiKey());
        Preconditions.checkArgument(!apiConfig.getApiKey().isEmpty());
        AppIdentityService appIdentityService = new AppIdentityService(apiConfig, new ObjectMapper());
        this.collector = new LogCollector(this.logger, apiConfig.getEnvDetail(), appIdentityService);
        if (Boolean.TRUE.equals(apiConfig.getAllowComDotStackify())) {
            this.allowComDotStackify = true;
        }
        LogTransport logTransport = this.getLogTransport(apiConfig);
        this.backgroundService = new LogBackgroundService(this.collector, logTransport);
        this.backgroundService.start();
    }

    protected LogTransport getLogTransport(@NonNull ApiConfiguration apiConfig) {
        if (apiConfig == null) {
            throw new NullPointerException("apiConfig is marked non-null but is null");
        }
        ObjectMapper objectMapper = new ObjectMapper();
        if (apiConfig.getTransport().equalsIgnoreCase("direct")) {
            return new LogTransportDirect(apiConfig, objectMapper, this.masker, this.skipJson);
        }
        if (apiConfig.getTransport().equalsIgnoreCase("agent_socket")) {
            return new LogTransportAgentSocket(apiConfig, this.masker, this.skipJson);
        }
        throw new IllegalArgumentException("Invalid Stackify Transport: " + apiConfig.getTransport());
    }

    @Override
    public void close() throws IOException {
        if (this.backgroundService != null) {
            this.backgroundService.stop();
        }
    }

    public void append(T event) {
        StackifyError e;
        String className;
        if (this.backgroundService == null) {
            return;
        }
        if (!this.backgroundService.isRunning()) {
            return;
        }
        if (!this.allowComDotStackify && (className = this.eventAdapter.getClassName(event)) != null && className.startsWith(COM_DOT_STACKIFY)) {
            return;
        }
        Throwable exception = this.eventAdapter.getThrowable(event);
        StackifyError error = null;
        if ((exception != null || this.eventAdapter.isErrorLevel(event)) && this.errorGovernor.errorShouldBeSent(e = this.eventAdapter.getStackifyError(event, exception))) {
            error = e;
        }
        LogMsg logMsg = this.eventAdapter.getLogMsg(event, error);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("#Log #Appender #Template Logging mesage: {}", event);
        }
        this.collector.addLogMsg(logMsg);
    }
}

