/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.models.errors.SDKError;
import com.stackone.stackone_client_java.models.operations.CrmListListsRequest;
import com.stackone.stackone_client_java.models.operations.CrmListListsResponse;
import com.stackone.stackone_client_java.models.operations.SDKMethodInterfaces;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;
import java.util.stream.Stream;

public class CrmListListsRequestBuilder {
    private CrmListListsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKMethodInterfaces.MethodCallCrmListLists sdk;

    public CrmListListsRequestBuilder(SDKMethodInterfaces.MethodCallCrmListLists sdk) {
        this.sdk = sdk;
    }

    public CrmListListsRequestBuilder request(CrmListListsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public CrmListListsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public CrmListListsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public CrmListListsResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        return this.sdk.listLists(this.request, options);
    }

    public Stream<CrmListListsResponse> callAsStream() {
        return Utils.stream(() -> Optional.of(this.call()), x -> {
            if (x.statusCode() >= 300) {
                byte[] body = Utils.toByteArrayAndClose(x.rawResponse().body());
                throw new SDKError(x.rawResponse(), x.statusCode(), x.contentType(), body);
            }
            return x.next();
        });
    }
}

