/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */


package com.stackone.stackone_client_java.models.components;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

public class StatusReason {

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("code")
    private JsonNullable<String> code;

    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("description")
    private JsonNullable<String> description;

    @JsonProperty("timestamp")
    private OffsetDateTime timestamp;

    @JsonCreator
    public StatusReason(
            @JsonProperty("code") JsonNullable<String> code,
            @JsonProperty("description") JsonNullable<String> description,
            @JsonProperty("timestamp") OffsetDateTime timestamp) {
        Utils.checkNotNull(code, "code");
        Utils.checkNotNull(description, "description");
        Utils.checkNotNull(timestamp, "timestamp");
        this.code = code;
        this.description = description;
        this.timestamp = timestamp;
    }
    
    public StatusReason(
            OffsetDateTime timestamp) {
        this(JsonNullable.undefined(), JsonNullable.undefined(), timestamp);
    }

    @JsonIgnore
    public JsonNullable<String> code() {
        return code;
    }

    @JsonIgnore
    public JsonNullable<String> description() {
        return description;
    }

    @JsonIgnore
    public OffsetDateTime timestamp() {
        return timestamp;
    }

    public final static Builder builder() {
        return new Builder();
    }

    public StatusReason withCode(String code) {
        Utils.checkNotNull(code, "code");
        this.code = JsonNullable.of(code);
        return this;
    }

    public StatusReason withCode(JsonNullable<String> code) {
        Utils.checkNotNull(code, "code");
        this.code = code;
        return this;
    }

    public StatusReason withDescription(String description) {
        Utils.checkNotNull(description, "description");
        this.description = JsonNullable.of(description);
        return this;
    }

    public StatusReason withDescription(JsonNullable<String> description) {
        Utils.checkNotNull(description, "description");
        this.description = description;
        return this;
    }

    public StatusReason withTimestamp(OffsetDateTime timestamp) {
        Utils.checkNotNull(timestamp, "timestamp");
        this.timestamp = timestamp;
        return this;
    }
    
    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        StatusReason other = (StatusReason) o;
        return 
            Objects.deepEquals(this.code, other.code) &&
            Objects.deepEquals(this.description, other.description) &&
            Objects.deepEquals(this.timestamp, other.timestamp);
    }
    
    @Override
    public int hashCode() {
        return Objects.hash(
            code,
            description,
            timestamp);
    }
    
    @Override
    public String toString() {
        return Utils.toString(StatusReason.class,
                "code", code,
                "description", description,
                "timestamp", timestamp);
    }
    
    public final static class Builder {
 
        private JsonNullable<String> code = JsonNullable.undefined();
 
        private JsonNullable<String> description = JsonNullable.undefined();
 
        private OffsetDateTime timestamp;  
        
        private Builder() {
          // force use of static builder() method
        }

        public Builder code(String code) {
            Utils.checkNotNull(code, "code");
            this.code = JsonNullable.of(code);
            return this;
        }

        public Builder code(JsonNullable<String> code) {
            Utils.checkNotNull(code, "code");
            this.code = code;
            return this;
        }

        public Builder description(String description) {
            Utils.checkNotNull(description, "description");
            this.description = JsonNullable.of(description);
            return this;
        }

        public Builder description(JsonNullable<String> description) {
            Utils.checkNotNull(description, "description");
            this.description = description;
            return this;
        }

        public Builder timestamp(OffsetDateTime timestamp) {
            Utils.checkNotNull(timestamp, "timestamp");
            this.timestamp = timestamp;
            return this;
        }
        
        public StatusReason build() {
            return new StatusReason(
                code,
                description,
                timestamp);
        }
    }
}

