/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java;

import com.stackone.stackone_client_java.Proxy;
import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.ProxyRequestBody;
import com.stackone.stackone_client_java.models.operations.StackoneProxyRequestRequest;
import com.stackone.stackone_client_java.models.operations.async.StackoneProxyRequestRequestBuilder;
import com.stackone.stackone_client_java.models.operations.async.StackoneProxyRequestResponse;
import com.stackone.stackone_client_java.operations.StackoneProxyRequest;
import com.stackone.stackone_client_java.utils.Options;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class AsyncProxy {
    private final SDKConfiguration sdkConfiguration;
    private final Proxy syncSDK;

    AsyncProxy(Proxy syncSDK, SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
        this.syncSDK = syncSDK;
    }

    public Proxy sync() {
        return this.syncSDK;
    }

    public StackoneProxyRequestRequestBuilder proxyRequest() {
        return new StackoneProxyRequestRequestBuilder(this.sdkConfiguration);
    }

    public CompletableFuture<StackoneProxyRequestResponse> proxyRequest(String xAccountId, ProxyRequestBody proxyRequestBody) {
        return this.proxyRequest(xAccountId, proxyRequestBody, Optional.empty());
    }

    public CompletableFuture<StackoneProxyRequestResponse> proxyRequest(String xAccountId, ProxyRequestBody proxyRequestBody, Optional<Options> options) {
        StackoneProxyRequestRequest request = StackoneProxyRequestRequest.builder().xAccountId(xAccountId).proxyRequestBody(proxyRequestBody).build();
        StackoneProxyRequest.Async operation = new StackoneProxyRequest.Async(this.sdkConfiguration, options, this.sdkConfiguration.retryScheduler());
        return operation.doRequest(request).thenCompose(operation::handleResponse);
    }
}

