/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.operations.HrisListLocationsRequest;
import com.stackone.stackone_client_java.models.operations.HrisListLocationsResponse;
import com.stackone.stackone_client_java.operations.HrisListLocations;
import com.stackone.stackone_client_java.utils.Exceptions;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import com.stackone.stackone_client_java.utils.pagination.CursorTracker;
import com.stackone.stackone_client_java.utils.pagination.Paginator;
import java.util.Optional;
import java.util.stream.Stream;

public class HrisListLocationsRequestBuilder {
    private HrisListLocationsRequest request;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public HrisListLocationsRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public HrisListLocationsRequestBuilder request(HrisListLocationsRequest request) {
        Utils.checkNotNull(request, "request");
        this.request = request;
        return this;
    }

    public HrisListLocationsRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public HrisListLocationsRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    public HrisListLocationsResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        HrisListLocations.Sync operation = new HrisListLocations.Sync(this.sdkConfiguration, options);
        return (HrisListLocationsResponse)operation.handleResponse(operation.doRequest(this.request));
    }

    public Iterable<HrisListLocationsResponse> callAsIterable() {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        HrisListLocations.Sync operation = new HrisListLocations.Sync(this.sdkConfiguration, options);
        Paginator<HrisListLocationsRequest, String> iterator = new Paginator<HrisListLocationsRequest, String>(this.request, new CursorTracker<String>("$.next", String.class), HrisListLocationsRequest::withNext, nextRequest -> Exceptions.unchecked(() -> operation.doRequest(this.request)).get());
        return () -> Utils.transform(iterator, operation::handleResponse);
    }

    public Stream<HrisListLocationsResponse> callAsStream() {
        return Utils.toStream(this.callAsIterable());
    }
}

