/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.stackone.stackone_client_java.models.components.ReferenceResult;
import com.stackone.stackone_client_java.utils.Response;
import com.stackone.stackone_client_java.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HrisGetTimeOffTypeResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends ReferenceResult> referenceResult;
    private Map<String, List<String>> headers;

    @JsonCreator
    public HrisGetTimeOffTypeResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends ReferenceResult> referenceResult, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(referenceResult, "referenceResult");
        headers = Utils.emptyMapIfNull(headers);
        Utils.checkNotNull(headers, "headers");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.referenceResult = referenceResult;
        this.headers = headers;
    }

    public HrisGetTimeOffTypeResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<ReferenceResult> referenceResult() {
        return this.referenceResult;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HrisGetTimeOffTypeResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public HrisGetTimeOffTypeResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public HrisGetTimeOffTypeResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public HrisGetTimeOffTypeResponse withReferenceResult(ReferenceResult referenceResult) {
        Utils.checkNotNull(referenceResult, "referenceResult");
        this.referenceResult = Optional.ofNullable(referenceResult);
        return this;
    }

    public HrisGetTimeOffTypeResponse withReferenceResult(Optional<? extends ReferenceResult> referenceResult) {
        Utils.checkNotNull(referenceResult, "referenceResult");
        this.referenceResult = referenceResult;
        return this;
    }

    public HrisGetTimeOffTypeResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HrisGetTimeOffTypeResponse other = (HrisGetTimeOffTypeResponse)o;
        return Utils.enhancedDeepEquals(this.contentType, other.contentType) && Utils.enhancedDeepEquals(this.statusCode, other.statusCode) && Utils.enhancedDeepEquals(this.rawResponse, other.rawResponse) && Utils.enhancedDeepEquals(this.referenceResult, other.referenceResult) && Utils.enhancedDeepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Utils.enhancedHash(this.contentType, this.statusCode, this.rawResponse, this.referenceResult, this.headers);
    }

    public String toString() {
        return Utils.toString(HrisGetTimeOffTypeResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "referenceResult", this.referenceResult, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends ReferenceResult> referenceResult = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder referenceResult(ReferenceResult referenceResult) {
            Utils.checkNotNull(referenceResult, "referenceResult");
            this.referenceResult = Optional.ofNullable(referenceResult);
            return this;
        }

        public Builder referenceResult(Optional<? extends ReferenceResult> referenceResult) {
            Utils.checkNotNull(referenceResult, "referenceResult");
            this.referenceResult = referenceResult;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public HrisGetTimeOffTypeResponse build() {
            return new HrisGetTimeOffTypeResponse(this.contentType, this.statusCode, this.rawResponse, this.referenceResult, this.headers);
        }
    }
}

